/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.htmlcompressor;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.io.Streams;

public class HtmlCompressingXmlPullParser
implements IXmlPullParser {
    private final IXmlPullParser delegate;
    private final HtmlCompressor compressor;

    public HtmlCompressingXmlPullParser(IXmlPullParser delegate, HtmlCompressor compressor) {
        this.delegate = delegate;
        this.compressor = compressor;
    }

    public void parse(CharSequence string) throws IOException {
        this.parse(new ByteArrayInputStream(string.toString().getBytes()), null);
    }

    public void parse(InputStream inputStream) throws IOException {
        this.parse(inputStream, "UTF-8");
    }

    public void parse(InputStream inputStream, String encoding) throws IOException {
        String markup = encoding != null ? Streams.readString((InputStream)inputStream, (CharSequence)encoding) : Streams.readString((InputStream)inputStream);
        String compressed = this.compressor.compress(markup);
        byte[] bytes = encoding != null ? compressed.getBytes(encoding) : compressed.getBytes();
        this.delegate.parse((InputStream)new ByteArrayInputStream(bytes), encoding);
    }

    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    public CharSequence getDoctype() {
        return this.delegate.getDoctype();
    }

    public CharSequence getInputFromPositionMarker(int toPos) {
        return this.delegate.getInputFromPositionMarker(toPos);
    }

    public CharSequence getInput(int fromPos, int toPos) {
        return this.delegate.getInput(fromPos, toPos);
    }

    public IXmlPullParser.HttpTagType next() throws ParseException {
        return this.delegate.next();
    }

    public XmlTag getElement() {
        return this.delegate.getElement();
    }

    public CharSequence getString() {
        return this.delegate.getString();
    }

    public void setPositionMarker() {
        this.delegate.setPositionMarker();
    }

    public void setPositionMarker(int pos) {
        this.delegate.setPositionMarker(pos);
    }

    public IXmlPullParser getDelegate() {
        return this.delegate;
    }

    public HtmlCompressor getCompressor() {
        return this.compressor;
    }
}

