/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid;

import com.inmethod.grid.IDataSource;
import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.IGridSortState;
import com.inmethod.grid.common.AbstractGrid;
import java.util.HashSet;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;

public class DataProviderAdapter<T, S>
implements IDataSource<T> {
    private static final long serialVersionUID = 1L;
    final IDataProvider<T> dataProvider;

    public DataProviderAdapter(IDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void detach() {
        this.dataProvider.detach();
    }

    @Override
    public IModel<T> model(T object) {
        return this.dataProvider.model(object);
    }

    private void setSortState(ISortState<S> dest, IGridSortState<S> gridSortState) {
        AbstractGrid<?, ?, S> grid = gridSortState.getGrid();
        HashSet<S> unsortedColumns = new HashSet<S>(grid.getAllColumns().size());
        for (IGridColumn<?, ?, S> iGridColumn : grid.getAllColumns()) {
            if (iGridColumn.getSortProperty() == null) continue;
            unsortedColumns.add(iGridColumn.getSortProperty());
        }
        for (IGridSortState.ISortStateColumn iSortStateColumn : gridSortState.getColumns()) {
            unsortedColumns.remove(iSortStateColumn.getPropertyName());
        }
        for (int i = gridSortState.getColumns().size(); i > 0; --i) {
            IGridSortState.ISortStateColumn<S> iSortStateColumn = gridSortState.getColumns().get(i - 1);
            SortOrder dir = SortOrder.NONE;
            if (iSortStateColumn.getDirection() == IGridSortState.Direction.ASC) {
                dir = SortOrder.ASCENDING;
            } else if (iSortStateColumn.getDirection() == IGridSortState.Direction.DESC) {
                dir = SortOrder.DESCENDING;
            }
            dest.setPropertySortOrder(iSortStateColumn.getPropertyName(), dir);
        }
    }

    @Override
    public void query(IDataSource.IQuery query, IDataSource.IQueryResult<T> result) {
        if (this.dataProvider instanceof ISortStateLocator) {
            ISortStateLocator locator = (ISortStateLocator)this.dataProvider;
            IGridSortState gridSortState = query.getSortState();
            ISortState state = locator.getSortState();
            if (state != null) {
                this.setSortState(state, gridSortState);
            }
        }
        result.setTotalCount(this.dataProvider.size());
        result.setItems(this.dataProvider.iterator(query.getFrom(), query.getCount()));
    }
}

