/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.column.AbstractColumn;
import com.inmethod.grid.datagrid.DataGrid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public class WicketColumnAdapter<M, I, S>
extends AbstractColumn<M, I, S> {
    private static final long serialVersionUID = 1L;
    private final IColumn<I, S> delegate;

    public WicketColumnAdapter(String columnId, IColumn<I, S> column) {
        super(columnId, null, null);
        this.delegate = column;
    }

    @Override
    public Component newCell(WebMarkupContainer parent, String componentId, IModel<I> rowModel) {
        Item item = this.getGrid() instanceof DataGrid ? (Item)parent.findParent(Item.class) : new Item("temp", 0, rowModel);
        this.delegate.populateItem(item, componentId, rowModel);
        Component component = item.get(componentId);
        item.remove(component);
        return component;
    }

    @Override
    public Component newHeader(String componentId) {
        return this.delegate.getHeader(componentId);
    }

    @Override
    public String getCellCssClass(IModel<I> rowModel, int rowNum) {
        if (this.delegate instanceof IStyledColumn) {
            return ((IStyledColumn)this.delegate).getCssClass();
        }
        return null;
    }

    @Override
    public S getSortProperty() {
        if (this.delegate.isSortable()) {
            return (S)this.delegate.getSortProperty();
        }
        return null;
    }

    public static <T, M, I, S> List<IGridColumn<M, I, S>> wrapColumns(IColumn<I, S>[] columns) {
        return WicketColumnAdapter.wrapColumns(Arrays.asList(columns));
    }

    public static <M, I, S> List<IGridColumn<M, I, S>> wrapColumns(List<IColumn<I, S>> columns) {
        ArrayList<IGridColumn<M, I, S>> result = new ArrayList<IGridColumn<M, I, S>>(columns.size());
        int i = 0;
        for (IColumn<I, S> column : columns) {
            result.add(new WicketColumnAdapter<M, I, S>("column" + i++, column));
        }
        return result;
    }
}

