/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.column.AbstractColumn;
import com.inmethod.grid.column.editable.EditableCellPanel;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

public class CheckBoxPanel<M, I, S>
extends EditableCellPanel<M, I, Boolean, S> {
    private static final long serialVersionUID = 1L;
    private static final String CheckBox_ID = "checkbox";

    public CheckBoxPanel(String id, IModel<Boolean> model, IModel<I> rowModel, AbstractColumn<M, I, S> column) {
        super(id, column, rowModel);
        CheckBox cb = this.newCheckBox(CheckBox_ID, model);
        cb.setOutputMarkupId(true);
        cb.setLabel(column.getHeaderModel());
        this.add(new Component[]{cb});
    }

    protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
        return new DefaultCheckBox(id, model);
    }

    @Override
    public FormComponent<Boolean> getEditComponent() {
        return (FormComponent)this.get(CheckBox_ID);
    }

    protected class DefaultCheckBox
    extends CheckBox {
        private static final long serialVersionUID = 1L;

        protected DefaultCheckBox(String id, IModel<Boolean> object) {
            super(id, object);
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            if (!this.isValid()) {
                tag.put("class", (CharSequence)"imxt-invalid");
                FeedbackMessage message = this.getFeedbackMessages().first();
                if (message != null) {
                    tag.put("title", (CharSequence)message.getMessage().toString());
                }
            }
        }
    }
}

