/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.column.AbstractColumn;
import com.inmethod.grid.column.editable.EditableCellPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;

public class DropDownChoicePanel<M, I, P, S>
extends EditableCellPanel<M, I, P, S> {
    private static final long serialVersionUID = 1L;
    private static final String DropDownChoice_ID = "DropDownChoice";

    public DropDownChoicePanel(String id, IModel<P> model, IModel<I> rowModel, AbstractColumn<M, I, S> column, IModel<? extends List<P>> choices, IChoiceRenderer<P> renderer) {
        super(id, column, rowModel);
        DropDownChoice<P> ddc = null == renderer ? this.newDropDownChoice(DropDownChoice_ID, model, choices) : this.newDropDownChoice(DropDownChoice_ID, model, choices, renderer);
        ddc.setOutputMarkupId(true);
        ddc.setLabel(column.getHeaderModel());
        this.add(new Component[]{ddc});
    }

    protected DropDownChoice<P> newDropDownChoice(String id, IModel<P> model, IModel<? extends List<P>> choices) {
        return new DefaultDropDownChoice<P>(id, model, choices);
    }

    protected DropDownChoice<P> newDropDownChoice(String id, IModel<P> model, IModel<? extends List<P>> choices, IChoiceRenderer<P> renderer) {
        return new DefaultDropDownChoice<P>(id, model, choices, renderer);
    }

    @Override
    public FormComponent<P> getEditComponent() {
        return (FormComponent)this.get(DropDownChoice_ID);
    }

    protected class DefaultDropDownChoice<P>
    extends DropDownChoice<P> {
        private static final long serialVersionUID = 1L;

        protected DefaultDropDownChoice(String id, IModel<P> object, IModel<? extends List<P>> choices) {
            super(id, object, choices);
        }

        protected DefaultDropDownChoice(String id, IModel<P> object, IModel<? extends List<P>> choices, IChoiceRenderer<P> renderer) {
            super(id, object, choices, renderer);
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            if (!this.isValid()) {
                tag.put("class", (CharSequence)"imxt-invalid");
                FeedbackMessage message = this.getFeedbackMessages().first();
                if (message != null) {
                    tag.put("title", (CharSequence)message.getMessage().toString());
                }
            }
        }
    }
}

