/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.column.AbstractColumn;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;

public abstract class EditableCellPanel<M, I, P, S>
extends Panel {
    private static final long serialVersionUID = 1L;
    private final AbstractColumn<M, I, S> column;

    public EditableCellPanel(String id, AbstractColumn<M, I, S> column, IModel<I> rowModel) {
        super(id, rowModel);
        this.column = column;
    }

    public AbstractColumn<M, I, S> getColumn() {
        return this.column;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        Component textField = this.get("textfield");
        if (target != null && this.isFocusTextField()) {
            target.focusComponent(textField);
        }
    }

    protected boolean isFocusTextField() {
        IGridColumn<M, I, S> lastClickedColumn = this.getColumn().getGrid().getLastClickedColumn();
        if (lastClickedColumn == this.getColumn()) {
            this.getColumn().getGrid().cleanLastClickedColumn();
            return true;
        }
        return false;
    }

    protected IModel<I> getDefaultRowModel() {
        return this.getDefaultModel();
    }

    public boolean isVisible() {
        return this.column.getGrid().isItemEdited(this.getDefaultRowModel());
    }

    protected abstract FormComponent<P> getEditComponent();
}

