/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.column.editable.EditableCellPanel;
import com.inmethod.grid.column.editable.TextFieldPanel;
import com.inmethod.grid.column.tree.PropertyTreeColumn;
import java.io.Serializable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class EditablePropertyTreeColumn<T extends TreeModel & Serializable, I extends TreeNode & Serializable, P, S>
extends PropertyTreeColumn<T, I, P, S> {
    private static final long serialVersionUID = 1L;

    public EditablePropertyTreeColumn(String columnId, IModel<String> headerModel, String propertyExpression, S sortProperty) {
        super(columnId, headerModel, propertyExpression, sortProperty);
    }

    public EditablePropertyTreeColumn(String columnId, IModel<String> headerModel, String propertyExpression) {
        super(columnId, headerModel, propertyExpression);
    }

    public EditablePropertyTreeColumn(IModel<String> headerModel, String propertyExpression, S sortProperty) {
        super(headerModel, propertyExpression, sortProperty);
    }

    public EditablePropertyTreeColumn(IModel<String> headerModel, String propertyExpression) {
        super(headerModel, propertyExpression);
    }

    @Override
    protected Component newNodeComponent(String id, IModel<I> model) {
        return new NodePanel(id, model);
    }

    protected void addValidators(FormComponent<P> component) {
    }

    protected IModel<P> getFieldModel(IModel<I> rowModel) {
        return new PropertyModel(rowModel, this.getPropertyExpression());
    }

    protected EditableCellPanel<T, I, P, S> newCellPanel(String componentId, IModel<I> rowModel, IModel<P> cellModel) {
        return new TextFieldPanel(componentId, cellModel, rowModel, this);
    }

    @Override
    public String getCellCssClass(IModel<I> rowModel, int rowNum) {
        if (this.isClickToEdit()) {
            if (this.getGrid().isItemEdited(rowModel)) {
                return "imxt-want-prelight imxt-edited-cell";
            }
            return "imxt-want-prelight";
        }
        if (this.getGrid().isItemEdited(rowModel)) {
            return "imxt-edited-cell";
        }
        return "";
    }

    @Override
    public boolean cellClicked(IModel<I> rowModel) {
        if (!this.isClickToEdit() || this.getGrid().isClickRowToSelect() && this.getGrid().isSelectToEdit()) {
            return false;
        }
        this.getGrid().setItemEdit(rowModel, true);
        this.getGrid().update();
        return true;
    }

    protected boolean isClickToEdit() {
        return true;
    }

    private class NodePanel
    extends Panel {
        private static final long serialVersionUID = 1L;

        public NodePanel(String id, final IModel<I> rowModel) {
            super(id);
            this.add(new Component[]{new Label("label", (IModel)new PropertyModel(rowModel, EditablePropertyTreeColumn.this.getPropertyExpression())){
                private static final long serialVersionUID = 1L;

                public boolean isVisible() {
                    return !EditablePropertyTreeColumn.this.getTreeGrid().isItemEdited(rowModel);
                }
            }});
            EditableCellPanel panel = EditablePropertyTreeColumn.this.newCellPanel("panel", rowModel, EditablePropertyTreeColumn.this.getFieldModel(rowModel));
            EditablePropertyTreeColumn.this.addValidators(panel.getEditComponent());
            this.add(new Component[]{panel});
        }
    }
}

