/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.tree;

import com.inmethod.grid.column.tree.AbstractTreeColumn;
import java.io.Serializable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class PropertyTreeColumn<T extends TreeModel & Serializable, I extends TreeNode & Serializable, P, S>
extends AbstractTreeColumn<T, I, S> {
    private static final long serialVersionUID = 1L;
    private final String propertyExpression;

    public PropertyTreeColumn(String columnId, IModel<String> headerModel, String propertyExpression, S sortProperty) {
        super(columnId, headerModel, sortProperty);
        this.propertyExpression = propertyExpression;
    }

    public PropertyTreeColumn(String columnId, IModel<String> headerModel, String propertyExpression) {
        this(columnId, headerModel, propertyExpression, null);
    }

    public PropertyTreeColumn(IModel<String> headerModel, String propertyExpression, S sortProperty) {
        this(propertyExpression, headerModel, propertyExpression, sortProperty);
    }

    public PropertyTreeColumn(IModel<String> headerModel, String propertyExpression) {
        this(propertyExpression, headerModel, propertyExpression);
    }

    @Override
    protected Component newNodeComponent(String id, IModel<I> model) {
        return new Label(id, (IModel)new PropertyModel(model, this.getPropertyExpression()));
    }

    protected String getPropertyExpression() {
        return this.propertyExpression;
    }
}

