/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.common;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.IRenderable;
import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.grid.common.GridSortState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;

public abstract class AbstractGridRow<M, I, S>
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;

    public AbstractGridRow(String id, IModel<I> model) {
        super(id, model);
    }

    protected void onBeforeRender() {
        Collection<IGridColumn<M, I, S>> activeColumns = this.getActiveColumns();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            if (this.isComponentNeeded(component.getId(), activeColumns)) continue;
            i.remove();
        }
        ArrayList<Component> components = new ArrayList<Component>(activeColumns.size());
        for (IGridColumn<M, I, S> column : activeColumns) {
            String componentId = this.componentId(column.getId());
            Component component = null;
            if (!column.isLightWeight(this.getDefaultRowModel()) && (component = this.get(componentId)) == null) {
                component = column.newCell(this, componentId, this.getDefaultRowModel());
                this.add(new Component[]{component});
            }
            if (component == null) continue;
            components.add(component);
        }
        super.onBeforeRender();
        for (Component component : components) {
            for (IGridColumn<M, I, S> column : activeColumns) {
                if (!component.getId().equals(this.componentId(column.getId()))) continue;
                component.add(new Behavior[]{new InnerDivClassBehavior(column)});
            }
        }
    }

    private boolean isColumnBeingSorted(IGridColumn<M, I, S> column) {
        if (column.getSortProperty() != null) {
            AbstractGrid dataGrid = (AbstractGrid)((Object)this.findParent(AbstractGrid.class));
            GridSortState sortState = dataGrid.getSortState();
            return sortState.getColumns().size() > 0 && sortState.getColumns().get(0).getPropertyName().equals(column.getSortProperty());
        }
        return false;
    }

    private int renderOpenTag(IGridColumn<M, I, S> column, int i, int columnsSize, Response response, int hide) {
        int originalColspan;
        int colspan = originalColspan = column.getColSpan(this.getDefaultRowModel());
        if (hide > 0) {
            response.write((CharSequence)"<td style=\"display:none\"");
            --hide;
        } else {
            response.write((CharSequence)"<td");
            int max = columnsSize - i;
            if (colspan > max) {
                colspan = max;
            }
            if (colspan > 1) {
                response.write((CharSequence)(" colspan=\"" + colspan + "\""));
                hide = colspan - 1;
            }
        }
        StringBuilder css = new StringBuilder();
        css.append("imxt-cell");
        String klass = column.getCellCssClass(this.getDefaultRowModel(), this.getRowNumber());
        if (klass != null) {
            css.append(" ");
            css.append(klass);
        }
        if (originalColspan > 1) {
            css.append(" imxt-colspan-");
            css.append(originalColspan);
        }
        if (this.isColumnBeingSorted(column)) {
            css.append(" imxt-sorted");
        }
        response.write((CharSequence)(" class=\"" + css.toString() + "\""));
        response.write((CharSequence)">");
        return hide;
    }

    private String getInnerDivClass(IGridColumn<M, I, S> column) {
        if (column.getWrapText()) {
            return "imxt-a imxt-wrap";
        }
        return "imxt-a imxt-nowrap";
    }

    protected void onRender() {
        Response response = RequestCycle.get().getResponse();
        Collection<IGridColumn<M, I, S>> columns = this.getActiveColumns();
        int hide = 0;
        int i = 0;
        for (IGridColumn<M, I, S> column : columns) {
            hide = this.renderOpenTag(column, i, columns.size(), response, hide);
            if (column.isLightWeight(this.getDefaultRowModel())) {
                IRenderable<I> renderable = column.newCell(this.getDefaultRowModel());
                if (renderable == null) {
                    throw new IllegalStateException("Lightweight columns must return valid IRenderable instance in newCell(IModel model)");
                }
                response.write((CharSequence)"<div class=\"");
                response.write((CharSequence)this.getInnerDivClass(column));
                response.write((CharSequence)"\">");
                renderable.render(this.getDefaultRowModel(), response);
                response.write((CharSequence)"</div>");
            } else {
                Component component = this.get(column.getId());
                if (component == null) {
                    throw new IllegalStateException("Column ID has changed during rendering");
                }
                IMarkupFragment componentMarkup = this.getMarkup();
                component.setMarkup(componentMarkup);
                component.render();
            }
            response.write((CharSequence)"</td>");
            ++i;
        }
    }

    private String componentId(String columnId) {
        return columnId;
    }

    protected abstract Collection<IGridColumn<M, I, S>> getActiveColumns();

    protected abstract int getRowNumber();

    private boolean isComponentNeeded(String componentId, Collection<IGridColumn<M, I, S>> activeColumns) {
        for (IGridColumn<M, I, S> column : activeColumns) {
            if (!this.componentId(column.getId()).equals(componentId) || column.isLightWeight(this.getDefaultRowModel())) continue;
            return true;
        }
        return false;
    }

    protected IModel<I> getDefaultRowModel() {
        return this.getDefaultModel();
    }

    private class InnerDivClassBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final IGridColumn<M, I, S> column;

        private InnerDivClassBehavior(IGridColumn<M, I, S> column) {
            this.column = column;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            String klass = tag.getAttribute("class");
            if (klass == null) {
                klass = "";
            }
            if (klass.length() > 0) {
                klass = klass + " ";
            }
            klass = klass + AbstractGridRow.this.getInnerDivClass(this.column);
            tag.put("class", (CharSequence)klass);
        }

        public boolean isTemporary(Component c) {
            return true;
        }
    }
}

