/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.common;

import com.inmethod.grid.IDataSource;
import com.inmethod.grid.IGridSortState;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;

public abstract class AbstractPageableView<T>
extends RefreshingView<T>
implements IPageable {
    private static final long serialVersionUID = 1L;
    public static final long UNKNOWN_COUNT = -1L;
    private long cachedPageCount = -1L;
    private long maxFirstItemReached;
    private long realItemCount = -1L;
    private long currentPageFirstItem = 0L;
    private transient QueryResult queryResult;

    public AbstractPageableView(String id, IModel<T> model) {
        super(id, model);
    }

    public AbstractPageableView(String id) {
        super(id);
    }

    public long getTotalRowCount() {
        this.initialize();
        return this.realItemCount;
    }

    public int getCurrentPageItemCount() {
        this.initialize();
        return this.queryResult.itemCache.size();
    }

    private long getItemCount() {
        this.initialize();
        if (this.realItemCount == -1L) {
            return this.maxFirstItemReached + this.getRowsPerPage() + 1L;
        }
        return this.realItemCount;
    }

    public long getCurrentPage() {
        return this.getCurrentPageFirstItem() / this.getRowsPerPage();
    }

    protected void onBeforeRender() {
        this.cachedPageCount = -1L;
        super.onBeforeRender();
    }

    public long getPageCount() {
        if (this.cachedPageCount == -1L) {
            long count = this.getItemCount();
            if (count == 0L) {
                this.cachedPageCount = 0L;
            } else {
                long rowsPerPage = this.getRowsPerPage();
                long mod = count % rowsPerPage;
                this.cachedPageCount = (count -= mod) / rowsPerPage + (long)(mod > 0L ? 1 : 0);
            }
        }
        return this.cachedPageCount;
    }

    public void setCurrentPage(long page) {
        long pageCount = this.getPageCount();
        if (page < 0L || page >= pageCount && pageCount > 0L) {
            throw new IndexOutOfBoundsException("Argument page is out of bounds");
        }
        long currentItem = this.getRowsPerPage() * page;
        this.setCurrentPageFirstItem(currentItem);
    }

    public void setMaxFirstItemReached(long maxFirstItemReached) {
        this.maxFirstItemReached = maxFirstItemReached;
    }

    public void clearCache() {
        this.queryResult = null;
        this.realItemCount = -1L;
    }

    protected IDataSource.IQuery wrapQuery(IDataSource.IQuery original) {
        return original;
    }

    private void initialize() {
        if (this.queryResult == null) {
            this.queryResult = new QueryResult();
            Query query = new Query(this.queryResult);
            IDataSource<T> dataSource = this.getDataSource();
            long oldItemCount = this.realItemCount;
            dataSource.query(this.wrapQuery(query), this.queryResult);
            this.queryResult.process(dataSource);
            if (this.queryResult.itemCache.size() == 0 && this.realItemCount != -1L && this.realItemCount != oldItemCount && this.realItemCount > 0L) {
                long page = this.getPageCount() - 1L;
                if (page < 0L) {
                    page = 0L;
                }
                this.setCurrentPage(page);
                this.queryResult = new QueryResult();
                query = new Query(this.queryResult);
                dataSource.query(query, this.queryResult);
                this.queryResult.process(dataSource);
            } else if (this.realItemCount == 0L) {
                QueryResult tmp = this.queryResult;
                this.setCurrentPage(0L);
                this.queryResult = tmp;
            }
        }
    }

    protected void onDetach() {
        super.onDetach();
        this.clearCache();
    }

    protected abstract IGridSortState getSortState();

    protected abstract IDataSource<T> getDataSource();

    protected abstract long getRowsPerPage();

    protected Iterator<IModel<T>> getItemModels() {
        this.initialize();
        return this.queryResult.itemCache.iterator();
    }

    private void setCurrentPageFirstItem(long currentItem) {
        if (this.currentPageFirstItem != currentItem) {
            if (this.maxFirstItemReached < currentItem) {
                this.maxFirstItemReached = currentItem;
            }
            this.currentPageFirstItem = currentItem;
            this.clearCache();
        }
    }

    private long getCurrentPageFirstItem() {
        long rowsPerPage = this.getRowsPerPage();
        return this.currentPageFirstItem - this.currentPageFirstItem % rowsPerPage;
    }

    private class QueryResult
    implements IDataSource.IQueryResult<T> {
        private Iterator<? extends T> items = new EmptyIterator();
        private long totalCount = AbstractPageableView.access$600(AbstractPageableView.this);
        private final ArrayList<IModel<T>> itemCache = new ArrayList();

        private QueryResult() {
        }

        @Override
        public void setItems(Iterator<? extends T> items) {
            this.items = items;
        }

        @Override
        public void setTotalCount(long count) {
            this.totalCount = count;
        }

        public void process(IDataSource<T> source) {
            long max = AbstractPageableView.this.getRowsPerPage();
            if (this.totalCount > 0L) {
                max = Math.min(max, this.totalCount - AbstractPageableView.this.getCurrentPageFirstItem());
            }
            while (max > 0L && this.items.hasNext()) {
                this.itemCache.add(source.model(this.items.next()));
                --max;
            }
            if (this.itemCache.size() == 0 && this.totalCount < 0L) {
                this.totalCount = this.totalCount == -2L ? 0L : AbstractPageableView.this.getCurrentPageFirstItem() + 1L;
            } else if (this.totalCount == -2L) {
                this.totalCount = AbstractPageableView.this.getCurrentPageFirstItem() + (long)this.itemCache.size();
            }
            if (this.totalCount != -1L || AbstractPageableView.this.getCurrentPage() == AbstractPageableView.this.getPageCount() || AbstractPageableView.this.realItemCount == -1L) {
                AbstractPageableView.this.realItemCount = this.totalCount;
            }
        }
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Query
    implements IDataSource.IQuery {
        QueryResult result;

        private Query(QueryResult result) {
            this.result = result;
        }

        @Override
        public long getCount() {
            long totalCount = this.getTotalCount();
            long rowsPerPage = AbstractPageableView.this.getRowsPerPage();
            long count = totalCount != -1L ? Math.min(totalCount - this.getFrom(), rowsPerPage) : rowsPerPage;
            return count >= 0L ? count : 0L;
        }

        @Override
        public long getFrom() {
            return AbstractPageableView.this.getCurrentPageFirstItem();
        }

        public IGridSortState getSortState() {
            return AbstractPageableView.this.getSortState();
        }

        @Override
        public long getTotalCount() {
            return this.result.totalCount;
        }
    }
}

