/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.common;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.IGridSortState;
import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.grid.common.GridSortState;
import com.inmethod.grid.common.SortableHeaderLinkPanel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public abstract class ColumnsHeaderRepeater<M, I, S>
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;

    public ColumnsHeaderRepeater(String id) {
        super(id);
    }

    protected void onBeforeRender() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            if (this.isComponentNeeded(component.getId())) continue;
            i.remove();
        }
        for (IGridColumn<M, I, S> column : this.getActiveColumns()) {
            String componentId = this.componentId(column.getId());
            if (this.get(componentId) == null) {
                if (column.getSortProperty() == null) {
                    Component component = column.newHeader(componentId);
                    if (!component.getId().equals(componentId)) {
                        throw new IllegalStateException("Invalid header component ID.");
                    }
                    this.add(new Component[]{component});
                } else {
                    SortableHeaderLinkPanel panel = new SortableHeaderLinkPanel<S>(componentId, column.getSortProperty()){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected void sortStateChanged(AjaxRequestTarget target) {
                            ColumnsHeaderRepeater.this.sortStateChanged(target);
                        }
                    };
                    Component component = column.newHeader("header");
                    if (!component.getId().equals("header")) {
                        throw new IllegalStateException("Invalid header component ID.");
                    }
                    panel.add(new Component[]{component});
                    this.add(new Component[]{panel});
                }
            }
            if (!column.getWrapText()) continue;
            this.get(componentId).add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)"white-space: normal;")), "; ")});
        }
        super.onBeforeRender();
    }

    protected abstract void sortStateChanged(AjaxRequestTarget var1);

    private GridSortState<S> getSortState() {
        return ((AbstractGrid)((Object)this.findParent(AbstractGrid.class))).getSortState();
    }

    private IGridSortState.Direction getSortDirection(IGridColumn<M, I, S> column) {
        GridSortState<S> state = this.getSortState();
        if (state.getColumns().size() > 0 && state.getColumns().get(0).getPropertyName().equals(column.getSortProperty())) {
            return state.getColumns().get(0).getDirection();
        }
        return null;
    }

    protected void onRender() {
        Response response = RequestCycle.get().getResponse();
        Collection<IGridColumn<M, I, S>> columns = this.getActiveColumns();
        for (IGridColumn<M, I, S> column : columns) {
            response.write((CharSequence)"<th style=\"width:");
            response.write((CharSequence)("" + this.getColumnWidth(column)));
            response.write((CharSequence)column.getSizeUnit().getValue());
            response.write((CharSequence)"\" class=\"imxt-want-prelight");
            if (!Strings.isEmpty((CharSequence)column.getHeaderCssClass())) {
                response.write((CharSequence)" ");
                response.write((CharSequence)column.getHeaderCssClass());
            }
            if (this.getSortDirection(column) != null) {
                response.write((CharSequence)" imxt-sorted");
            }
            response.write((CharSequence)"\">");
            response.write((CharSequence)"<div class=\"imxt-a\">");
            response.write((CharSequence)"<div class=\"imxt-b\">");
            Component component = this.get(this.componentId(column.getId()));
            if (component == null) {
                throw new IllegalStateException("Column ID has changed during rendering");
            }
            IMarkupFragment componentMarkup = component.getParent().getMarkup();
            component.setMarkup(componentMarkup);
            component.render();
            response.write((CharSequence)"</div>");
            if (column.isResizable()) {
                response.write((CharSequence)"<a class=\"imxt-handle\" href=\"#\" onclick=\"return false\"></a>");
            }
            response.write((CharSequence)"</div></th>");
        }
    }

    private boolean isComponentNeeded(String componentId) {
        for (IGridColumn<M, I, S> column : this.getActiveColumns()) {
            if (!this.componentId(column.getId()).equals(componentId)) continue;
            return true;
        }
        return false;
    }

    private String componentId(String columnId) {
        return columnId.replace(".", "-");
    }

    abstract Collection<IGridColumn<M, I, S>> getActiveColumns();

    abstract int getColumnWidth(IGridColumn<M, I, S> var1);
}

