/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.common;

import com.inmethod.grid.IGridSortState;
import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.grid.common.GridSortState;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class SortableHeaderLinkPanel<S>
extends Panel {
    private static final long serialVersionUID = 1L;
    private final S sortProperty;
    public static final String COMPONENT_ID = "header";

    public SortableHeaderLinkPanel(String id, S sortProperty) {
        super(id);
        this.sortProperty = sortProperty;
        this.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                IGridSortState.Direction direction = SortableHeaderLinkPanel.this.getSortDirection();
                if (direction == IGridSortState.Direction.ASC) {
                    SortableHeaderLinkPanel.this.getSortState().setSortState(SortableHeaderLinkPanel.this.sortProperty, IGridSortState.Direction.DESC);
                } else {
                    SortableHeaderLinkPanel.this.getSortState().setSortState(SortableHeaderLinkPanel.this.sortProperty, IGridSortState.Direction.ASC);
                }
                SortableHeaderLinkPanel.this.sortStateChanged(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setPreventDefault(true);
            }
        }});
    }

    protected abstract void sortStateChanged(AjaxRequestTarget var1);

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setName("a");
        tag.put("href", (CharSequence)"#");
        tag.put("class", (CharSequence)this.getStyleClass());
    }

    private GridSortState<S> getSortState() {
        return ((AbstractGrid)((Object)this.findParent(AbstractGrid.class))).getSortState();
    }

    private IGridSortState.Direction getSortDirection() {
        GridSortState<S> state = this.getSortState();
        if (state.getColumns().size() > 0 && state.getColumns().get(0).getPropertyName().equals(this.sortProperty)) {
            return state.getColumns().get(0).getDirection();
        }
        return null;
    }

    private String getStyleClass() {
        IGridSortState.Direction direction = this.getSortDirection();
        if (direction == IGridSortState.Direction.ASC) {
            return "imxt-sort-header imxt-sort-header-asc";
        }
        if (direction == IGridSortState.Direction.DESC) {
            return "imxt-sort-header imxt-sort-header-desc";
        }
        return "imxt-sort-header imxt-sort-header-none";
    }
}

