/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.datagrid;

import com.inmethod.grid.IAppendableDataSource;
import com.inmethod.grid.IDataSource;
import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.IGridSortState;
import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.grid.datagrid.DataGridBody;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;

public class DataGrid<D extends IDataSource<T>, T, S>
extends AbstractGrid<D, T, S>
implements IPageable {
    private static final long serialVersionUID = 1L;
    private long rowsPerPage = 20L;
    private final Set<IModel<T>> selectedItems = new HashSet<IModel<T>>();
    private boolean allowSelectMultiple = true;
    private boolean cleanSelectionOnPageChange = true;
    private transient Set<IModel<T>> dirtyItems = null;
    private transient boolean allDirty = false;

    public DataGrid(String id, IModel<D> model, List<IGridColumn<D, T, S>> columns) {
        super(id, model, columns);
        this.init();
    }

    public DataGrid(String id, D dataSource, List<IGridColumn<D, T, S>> columns) {
        this(id, Model.of(dataSource), columns);
    }

    public D getDataSource() {
        return (D)((IDataSource)this.getDefaultModelObject());
    }

    public DataGrid<D, T, S> setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
        return this;
    }

    public long getRowsPerPage() {
        return this.rowsPerPage;
    }

    private void init() {
        ((WebMarkupContainer)this.get("form:bodyContainer")).add(new Component[]{new Body("body")});
    }

    private Body getBody() {
        return (Body)this.get("form:bodyContainer:body");
    }

    public long getTotalRowCount() {
        return this.getBody().getTotalRowCount();
    }

    public long getCurrentPage() {
        return this.getBody().getCurrentPage();
    }

    public long getPageCount() {
        return this.getBody().getPageCount();
    }

    public void setCurrentPage(long page) {
        if (this.getBody().getCurrentPage() != page) {
            this.getBody().setCurrentPage(page);
            if (this.isCleanSelectionOnPageChange()) {
                this.resetSelectedItems();
            }
        }
    }

    public long getCurrentPageItemCount() {
        return this.getBody().getCurrentPageItemCount();
    }

    @Override
    public Collection<IModel<T>> getSelectedItems() {
        return Collections.unmodifiableSet(this.selectedItems);
    }

    @Override
    public boolean isAllowSelectMultiple() {
        return this.allowSelectMultiple;
    }

    @Override
    public void setAllowSelectMultiple(boolean value) {
        this.allowSelectMultiple = value;
    }

    public DataGrid<D, T, S> setCleanSelectionOnPageChange(boolean cleanSelectionOnPageChange) {
        this.cleanSelectionOnPageChange = cleanSelectionOnPageChange;
        return this;
    }

    public boolean isCleanSelectionOnPageChange() {
        return this.cleanSelectionOnPageChange;
    }

    @Override
    public boolean isItemSelected(IModel<T> itemModel) {
        return this.selectedItems.contains(itemModel);
    }

    @Override
    public void resetSelectedItems() {
        this.markAllItemsDirty();
        HashSet<IModel<T>> oldSelected = new HashSet<IModel<T>>(this.selectedItems);
        this.selectedItems.clear();
        for (IModel iModel : oldSelected) {
            this.onItemSelectionChanged((IModel<T>)iModel, false);
        }
    }

    @Override
    public void selectAllVisibleItems() {
        WebMarkupContainer body = (WebMarkupContainer)this.get("form:bodyContainer:body:row");
        if (body != null) {
            for (Component component : body) {
                IModel model = component.getDefaultModel();
                this.selectItem((IModel<T>)model, true);
            }
        }
        this.markAllItemsDirty();
    }

    @Override
    protected WebMarkupContainer findRowComponent(IModel<T> rowModel) {
        if (rowModel == null) {
            throw new IllegalArgumentException("rowModel may not be null");
        }
        WebMarkupContainer body = (WebMarkupContainer)this.get("form:bodyContainer:body:row");
        if (body != null) {
            for (Component component : body) {
                IModel model = component.getDefaultModel();
                if (!rowModel.equals((Object)model)) continue;
                return (WebMarkupContainer)component;
            }
        }
        return null;
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        this.dirtyItems = null;
        this.allDirty = false;
    }

    @Override
    public void markItemDirty(IModel<T> itemModel) {
        if (!this.allDirty) {
            if (this.dirtyItems == null) {
                this.dirtyItems = new HashSet<IModel<T>>();
            }
            this.dirtyItems.add(itemModel);
        }
    }

    public void markAllItemsDirty() {
        this.allDirty = true;
        this.dirtyItems = null;
    }

    @Override
    public void onItemSelectionChanged(IModel<T> item, boolean newValue) {
        this.markItemDirty(item);
    }

    @Override
    public void update() {
        WebMarkupContainer body;
        AjaxRequestTarget target = (AjaxRequestTarget)this.getRequestCycle().find(AjaxRequestTarget.class);
        if (this.allDirty) {
            target.add(new Component[]{this});
        } else if (this.dirtyItems != null && (body = (WebMarkupContainer)this.get("form:bodyContainer:body:row")) != null) {
            for (Component component : body) {
                IModel model = component.getDefaultModel();
                if (!this.dirtyItems.contains(model)) continue;
                target.add(new Component[]{component});
            }
        }
        this.dirtyItems = null;
    }

    public Item<T> insertRow(T rowData) {
        IAppendableDataSource ADS;
        try {
            ADS = (IAppendableDataSource)this.getDataSource();
        }
        catch (ClassCastException cce) {
            throw new WicketRuntimeException("Error BAD Data Source type. IAppendableDataSource REQUIRED for addition", (Throwable)cce);
        }
        ADS.insertRow(this.getCurrentPageItemCount(), rowData);
        Item<T> item = this.getBody().createItem(this.getCurrentPageItemCount(), this.getDataSource().model(rowData));
        this.getBody().clearCache();
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        target.add(new Component[]{this.getParent()});
        return item;
    }

    @Override
    public void selectItem(IModel<T> itemModel, boolean selected) {
        if (!this.isAllowSelectMultiple() && this.selectedItems.size() > 0) {
            Iterator<IModel<T>> i = this.selectedItems.iterator();
            while (i.hasNext()) {
                IModel<T> current = i.next();
                if (current.equals(itemModel)) continue;
                i.remove();
                this.onItemSelectionChanged(current, false);
            }
        }
        if (selected && !this.selectedItems.contains(itemModel)) {
            this.selectedItems.add(itemModel);
            this.onItemSelectionChanged(itemModel, selected);
        } else if (!selected && this.selectedItems.contains(itemModel)) {
            this.selectedItems.remove(itemModel);
            this.onItemSelectionChanged(itemModel, selected);
        }
    }

    @Override
    public WebMarkupContainer findParentRow(Component child) {
        return (WebMarkupContainer)child.findParent(DataGridBody.Data.RowItem.class);
    }

    public static interface IGridQuery
    extends IDataSource.IQuery {
        public DataGrid<?, ?, ?> getDataGrid();
    }

    private class Body
    extends DataGridBody<D, T, S> {
        private static final long serialVersionUID = 1L;

        private Body(String id) {
            super(id);
        }

        @Override
        protected Collection<IGridColumn<D, T, S>> getActiveColumns() {
            return DataGrid.this.getActiveColumns();
        }

        @Override
        protected D getDataSource() {
            return DataGrid.this.getDataSource();
        }

        @Override
        protected long getRowsPerPage() {
            return DataGrid.this.getRowsPerPage();
        }

        @Override
        protected IGridSortState<S> getSortState() {
            return DataGrid.this.getSortState();
        }

        @Override
        protected boolean isItemSelected(IModel<T> itemModel) {
            return DataGrid.this.isItemSelected(itemModel);
        }

        @Override
        protected void rowPopulated(WebMarkupContainer rowItem) {
            DataGrid.this.onRowPopulated(rowItem);
        }
    }
}

