/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.toolbar;

import com.inmethod.grid.IDataSource;
import com.inmethod.grid.datagrid.DataGrid;
import com.inmethod.grid.toolbar.AbstractToolbar;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class AddRecordsToolbar<D extends IDataSource<T>, T extends Serializable, S>
extends AbstractToolbar<D, T, S> {
    private static final IModel<String> ADD_BUTTON_MODEL = new ResourceModel("datagrid.add-new-item", "Add New Item");
    private DataGrid<D, T, S> grid;
    private final T defaultObject;

    public AddRecordsToolbar(DataGrid<D, T, S> grid, IModel<T> model, T defaultObject) {
        this(grid, model, defaultObject, ADD_BUTTON_MODEL);
    }

    public AddRecordsToolbar(DataGrid<D, T, S> datagrid, IModel<T> model, T defaultObject, IModel<String> labelModel) {
        super(datagrid, labelModel);
        this.grid = datagrid;
        datagrid.setOutputMarkupId(true);
        if (null != datagrid.getParent()) {
            datagrid.getParent().setOutputMarkupId(true);
        }
        this.defaultObject = defaultObject;
        Form form = new Form("addForm");
        this.add(new Component[]{form});
        AjaxButton addButton = new AjaxButton("add"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                AddRecordsToolbar.this.insert();
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        addButton.setLabel(labelModel);
        form.add(new Component[]{addButton});
    }

    protected void insert() {
        long pre = 0L;
        long post = 0L;
        pre = this.grid.getTotalRowCount();
        this.grid.insertRow(this.getNewData());
        post = this.grid.getTotalRowCount();
        this.grid.update();
    }

    protected T getNewData() {
        if (this.defaultObject == null) {
            throw new WicketRuntimeException("Can't deep copy a null object.");
        }
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteArray);
            oos.writeObject(this.defaultObject);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(byteArray.toByteArray()));
            Object obj = ois.readObject();
            return (T)((Serializable)obj);
        }
        catch (IOException ioe) {
        }
        catch (ClassNotFoundException cnf) {
            // empty catch block
        }
        return this.defaultObject;
    }
}

