/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.treegrid;

import com.inmethod.grid.column.AbstractColumn;
import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.grid.treegrid.AbstractTreeGridRow;
import com.inmethod.grid.treegrid.TreeGrid;
import com.inmethod.grid.treegrid.TreePanel;
import com.inmethod.icon.Icon;
import java.io.Serializable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public abstract class BaseTreeColumn<T extends TreeModel & Serializable, I extends TreeNode & Serializable, S>
extends AbstractColumn<T, I, S> {
    private static final long serialVersionUID = 1L;

    public BaseTreeColumn(String columnId, IModel<String> headerModel, S sortProperty) {
        super(columnId, headerModel, sortProperty);
    }

    public BaseTreeColumn(String columnId, IModel<String> headerModel) {
        super(columnId, headerModel);
    }

    @Override
    public Component newCell(WebMarkupContainer parent, String componentId, IModel<I> rowModel) {
        if (!(parent instanceof AbstractTreeGridRow)) {
            throw new IllegalArgumentException("Parent must be an " + AbstractTreeGridRow.class);
        }
        AbstractTreeGridRow row = (AbstractTreeGridRow)parent;
        return new TreePanel<T, I>(componentId, rowModel, row.getLevel()){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component newNodeComponent(String id, IModel<I> model) {
                return BaseTreeColumn.this.newNodeComponent(id, model);
            }

            @Override
            protected Icon getIcon(IModel<I> model) {
                return BaseTreeColumn.this.getIcon(model);
            }

            @Override
            protected void onJunctionLinkClicked(AjaxRequestTarget target, Object node) {
                BaseTreeColumn.this.getTreeGrid().onJunctionLinkClicked(target, node);
            }
        };
    }

    protected abstract Component newNodeComponent(String var1, IModel<I> var2);

    protected abstract Icon getIcon(IModel<I> var1);

    public TreeGrid<T, I, S> getTreeGrid() {
        return (TreeGrid)this.getGrid();
    }

    @Override
    public void setGrid(AbstractGrid<T, I, S> grid) {
        if (this.getTreeGrid() != null && this.getTreeGrid() != grid) {
            throw new IllegalStateException("One BaseTreeColumn can not be used with multiple TreeGrid instances");
        }
        if (!(grid instanceof TreeGrid)) {
            throw new IllegalStateException("BaseTreeColumn can only be added to a TreeGrid.");
        }
        super.setGrid(grid);
    }
}

