/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.treegrid;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.grid.treegrid.AbstractTreeGridRow;
import com.inmethod.grid.treegrid.TreeGridBody;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.tree.DefaultTreeState;
import org.apache.wicket.extensions.markup.html.tree.ITreeState;
import org.apache.wicket.extensions.markup.html.tree.ITreeStateListener;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TreeGrid<T extends TreeModel & Serializable, I extends TreeNode & Serializable, S>
extends AbstractGrid<T, I, S> {
    private static final long serialVersionUID = 1L;
    private TreeGridBody<T, I, S> body;
    private boolean autoSelectChildren = true;

    public TreeGrid(String id, IModel<T> model, List<IGridColumn<T, I, S>> columns) {
        super(id, model, columns);
        WebMarkupContainer bodyContainer = (WebMarkupContainer)this.get("form:bodyContainer");
        Component[] componentArray = new Component[1];
        this.body = new TreeGridBody<T, I, S>("body", model){
            private static final long serialVersionUID = 1L;

            @Override
            protected Collection<IGridColumn<T, I, S>> getActiveColumns() {
                return TreeGrid.this.getActiveColumns();
            }

            @Override
            protected void rowPopulated(WebMarkupContainer item) {
                TreeGrid.this.onRowPopulated(item);
            }

            protected ITreeState newTreeState() {
                return TreeGrid.this.newTreeState();
            }
        };
        componentArray[0] = this.body;
        bodyContainer.add(componentArray);
        this.getTreeState().addTreeStateListener((ITreeStateListener)new TreeStateListener());
    }

    private ITreeState newTreeState() {
        return new DefaultTreeState(){
            private static final long serialVersionUID = 1L;

            public boolean isNodeSelected(Object node) {
                if (!TreeGrid.this.isAutoSelectChildren()) {
                    return super.isNodeSelected(node);
                }
                Object parent = node;
                while (parent != null) {
                    if (super.isNodeSelected(parent)) {
                        return true;
                    }
                    parent = TreeGrid.this.getTree().getParentNode(parent);
                }
                return false;
            }

            private void deselectChildNodes(Object node) {
                ArrayList toDeselect = new ArrayList();
                for (Object o : this.getSelectedNodes()) {
                    Object p = TreeGrid.this.getTree().getParentNode(o);
                    while (p != null && !p.equals(node)) {
                        p = TreeGrid.this.getTree().getParentNode(p);
                    }
                    if (p == null) continue;
                    toDeselect.add(o);
                }
                for (Object o : toDeselect) {
                    this.removeSelectedNodeSilent(o);
                }
            }

            public void selectNode(Object node, boolean selected) {
                if (!TreeGrid.this.isAutoSelectChildren()) {
                    super.selectNode(node, selected);
                } else {
                    Object parent = TreeGrid.this.getTree().getParentNode(node);
                    while (parent != null) {
                        if (super.isNodeSelected(parent)) {
                            return;
                        }
                        parent = TreeGrid.this.getTree().getParentNode(parent);
                    }
                    this.deselectChildNodes(node);
                    if (super.isNodeSelected(node) != selected) {
                        super.selectNode(node, selected);
                        TreeGrid.this.getTree().markNodeChildrenDirty(node);
                    }
                }
            }
        };
    }

    public TreeGrid(String id, T model, List<IGridColumn<T, I, S>> columns) {
        this(id, Model.of((Serializable)((Serializable)model)), columns);
    }

    public AbstractTree getTree() {
        return this.body;
    }

    public ITreeState getTreeState() {
        return this.getTree().getTreeState();
    }

    @Override
    public final void update() {
        this.getTree().updateTree((AjaxRequestTarget)this.getRequestCycle().find(AjaxRequestTarget.class));
    }

    protected void onJunctionLinkClicked(AjaxRequestTarget target, Object node) {
    }

    @Override
    public Collection<IModel<I>> getSelectedItems() {
        Collection nodes = this.getTreeState().getSelectedNodes();
        ArrayList<IModel<I>> result = new ArrayList<IModel<I>>(nodes.size());
        for (Object node : nodes) {
            result.add((IModel<I>)new Model((Serializable)((Object)((TreeNode)node))));
        }
        return result;
    }

    @Override
    public boolean isAllowSelectMultiple() {
        return this.getTreeState().isAllowSelectMultiple();
    }

    @Override
    public void setAllowSelectMultiple(boolean value) {
        this.getTreeState().setAllowSelectMultiple(value);
    }

    @Override
    public boolean isItemSelected(IModel<I> itemModel) {
        return this.getTreeState().isNodeSelected(itemModel.getObject());
    }

    @Override
    public void resetSelectedItems() {
        Collection nodes = this.getTreeState().getSelectedNodes();
        for (Object node : nodes) {
            this.getTreeState().selectNode(node, false);
        }
        this.getTree().invalidateAll();
    }

    @Override
    public void selectAllVisibleItems() {
        WebMarkupContainer body = (WebMarkupContainer)this.get("form:bodyContainer:body:i");
        if (body != null) {
            boolean first = true;
            for (Component component : body) {
                if (!this.getTree().isRootLess() || !first) {
                    this.selectItem(component.getDefaultModel(), true);
                }
                first = false;
            }
        }
        this.getTree().invalidateAll();
    }

    @Override
    protected WebMarkupContainer findRowComponent(IModel<I> rowModel) {
        if (rowModel == null) {
            throw new IllegalArgumentException("rowModel may not be null");
        }
        WebMarkupContainer body = (WebMarkupContainer)this.get("form:bodyContainer:body:i");
        if (body != null) {
            for (Component component : body) {
                IModel model = component.getDefaultModel();
                if (!rowModel.equals((Object)model)) continue;
                return (WebMarkupContainer)component;
            }
        }
        return null;
    }

    @Override
    public void markItemDirty(IModel<I> model) {
        Object node = model.getObject();
        this.getTree().markNodeDirty(node);
    }

    @Override
    public void selectItem(IModel<I> itemModel, boolean selected) {
        this.getTreeState().selectNode(itemModel.getObject(), selected);
    }

    @Override
    public WebMarkupContainer findParentRow(Component child) {
        if (!(child instanceof AbstractTreeGridRow)) {
            child = (Component)child.findParent(AbstractTreeGridRow.class);
        }
        return (WebMarkupContainer)(child != null ? child.getParent() : null);
    }

    public void setAutoSelectChildren(boolean autoSelectChildren) {
        this.autoSelectChildren = autoSelectChildren;
    }

    public boolean isAutoSelectChildren() {
        return this.isAllowSelectMultiple() && !this.isSelectToEdit() && this.autoSelectChildren;
    }

    private class TreeStateListener
    implements ITreeStateListener {
        private static final long serialVersionUID = 1L;

        private TreeStateListener() {
        }

        public void allNodesCollapsed() {
        }

        public void allNodesExpanded() {
        }

        public void nodeCollapsed(Object node) {
        }

        public void nodeExpanded(Object node) {
        }

        public void nodeSelected(Object node) {
            TreeGrid.this.onItemSelectionChanged((IModel)new Model((Serializable)((Object)((TreeNode)node))), true);
        }

        public void nodeUnselected(Object node) {
            TreeGrid.this.onItemSelectionChanged((IModel)new Model((Serializable)((Object)((TreeNode)node))), false);
        }
    }
}

