/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.treegrid;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.common.AttachPrelightBehavior;
import com.inmethod.grid.treegrid.AbstractTreeGridRow;
import com.inmethod.grid.treegrid.TreeGrid;
import java.util.Collection;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tree.AbstractTree;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public abstract class TreeGridBody<T extends TreeModel, I extends TreeNode, S>
extends AbstractTree {
    private static final long serialVersionUID = 1L;

    public TreeGridBody(String id, IModel<T> model) {
        super(id, model);
        this.setRenderBodyOnly(true);
    }

    protected void populateTreeItem(final WebMarkupContainer item, int level) {
        AbstractTreeGridRow row = new AbstractTreeGridRow<T, I, S>("item", item.getDefaultModel(), level){
            private static final long serialVersionUID = 1L;

            @Override
            protected Collection<IGridColumn<T, I, S>> getActiveColumns() {
                return TreeGridBody.this.getActiveColumns();
            }

            @Override
            protected int getRowNumber() {
                return -1;
            }
        };
        item.add(new Component[]{row});
        item.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                String klass = "imxt-want-prelight imxt-grid-row";
                if (TreeGridBody.this.getTreeState().isNodeSelected(item.getDefaultModelObject())) {
                    klass = klass + " imxt-selected";
                }
                tag.put("class", (CharSequence)klass);
            }
        }});
        item.add(new Behavior[]{new AttachPrelightBehavior()});
        this.rowPopulated(item);
    }

    protected void addComponent(AjaxRequestTarget target, Component component) {
        if (component == this) {
            target.add(new Component[]{(Component)this.findParent(TreeGrid.class)});
        } else {
            super.addComponent(target, component);
        }
    }

    protected boolean isForceRebuildOnSelectionChange() {
        return false;
    }

    boolean isNodeExpanded2(Object object) {
        return super.isNodeExpanded(object);
    }

    protected abstract Collection<IGridColumn<T, I, S>> getActiveColumns();

    protected abstract void rowPopulated(WebMarkupContainer var1);
}

