/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.treegrid;

import com.inmethod.grid.treegrid.TreeGridBody;
import com.inmethod.icon.Icon;
import com.inmethod.icon.IconImage;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.io.IClusterable;

public abstract class TreePanel<T extends TreeModel, I extends TreeNode>
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String JUNCTION_LINK_ID = "junctionLink";
    private static final String NODE_COMPONENT_ID = "nodeComponent";
    private final int level;

    public TreePanel(String id, IModel<I> model, int level) {
        super(id, model);
        this.level = level;
    }

    protected void onInitialize() {
        super.onInitialize();
        Object node = this.getDefaultModelObject();
        Component junctionLink = this.newJunctionLink((MarkupContainer)this, JUNCTION_LINK_ID, node);
        junctionLink.add(new Behavior[]{new JunctionBorder(node, this.level)});
        this.add(new Component[]{junctionLink});
        Component nodeComponent = this.newNodeComponent(NODE_COMPONENT_ID, this.getDefaultNodeModel());
        this.add(new Component[]{nodeComponent});
        IconImage icon = new IconImage("icon", new IconModel()){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return this.getIcon() != null;
            }
        };
        icon.add(new Behavior[]{IconBorder.INSTANCE});
        this.add(new Component[]{icon});
    }

    public IconImage getIconComponent() {
        return (IconImage)this.get("icon");
    }

    protected abstract Icon getIcon(IModel<I> var1);

    protected abstract Component newNodeComponent(String var1, IModel<I> var2);

    protected IModel<I> getDefaultNodeModel() {
        return this.getDefaultModel();
    }

    private TreeGridBody<T, I, ?> getTreeGridBody() {
        return (TreeGridBody)((Object)this.findParent(TreeGridBody.class));
    }

    protected Component newJunctionLink(MarkupContainer parent, String id, final Object node) {
        WebMarkupContainer junctionLink;
        TreeModel model = (TreeModel)this.getTreeGridBody().getDefaultModelObject();
        if (!model.isLeaf(node)) {
            junctionLink = this.newLink(id, new ILinkCallback(){
                private static final long serialVersionUID = 1L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    if (TreePanel.this.getTreeGridBody().isNodeExpanded2(node)) {
                        TreePanel.this.getTreeGridBody().getTreeState().collapseNode(node);
                    } else {
                        TreePanel.this.getTreeGridBody().getTreeState().expandNode(node);
                    }
                    TreePanel.this.onJunctionLinkClicked(target, node);
                    TreePanel.this.getTreeGridBody().updateTree(target);
                }
            });
            junctionLink.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    if (TreePanel.this.getTreeGridBody().isNodeExpanded2(node)) {
                        tag.put("class", (CharSequence)"imxt-junction-open");
                    } else {
                        tag.put("class", (CharSequence)"imxt-junction-closed");
                    }
                }
            }});
        } else {
            junctionLink = new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.setName("span");
                }
            };
        }
        return junctionLink;
    }

    public MarkupContainer newLink(String id, final ILinkCallback callback) {
        return new AjaxSubmitLink(id){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                callback.onClick(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        }.setDefaultFormProcessing(false);
    }

    protected abstract void onJunctionLinkClicked(AjaxRequestTarget var1, Object var2);

    public static interface ILinkCallback
    extends IClusterable {
        public void onClick(AjaxRequestTarget var1);
    }

    private static class JunctionBorder
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final int level;

        public JunctionBorder(Object node, int level) {
            this.level = level;
        }

        public void afterRender(Component component) {
            RequestCycle.get().getResponse().write((CharSequence)"</td>");
        }

        public void beforeRender(Component component) {
            Response response = RequestCycle.get().getResponse();
            for (int i = this.level - 1; i >= 0; --i) {
                response.write((CharSequence)"<td class=\"imxt-spacer\"><span></span></td>");
            }
            response.write((CharSequence)"<td class=\"imxt-spacer\">");
        }
    }

    private static class IconBorder
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private static final IconBorder INSTANCE = new IconBorder();

        private IconBorder() {
        }

        public void beforeRender(Component component) {
            RequestCycle.get().getResponse().write((CharSequence)"<td>");
        }

        public void afterRender(Component component) {
            RequestCycle.get().getResponse().write((CharSequence)"</td>");
        }
    }

    private class IconModel
    implements IModel<Icon> {
        private static final long serialVersionUID = 1L;

        private IconModel() {
        }

        public Icon getObject() {
            return TreePanel.this.getIcon(TreePanel.this.getDefaultNodeModel());
        }

        public void setObject(Icon object) {
            throw new UnsupportedOperationException();
        }

        public void detach() {
        }
    }
}

