/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.javaee.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateful;
import javax.persistence.PersistenceUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.javaee.EntityManagerFactoryLocator;
import org.wicketstuff.javaee.JavaEEBeanLocator;
import org.wicketstuff.javaee.JndiObjectLocator;
import org.wicketstuff.javaee.naming.IJndiNamingStrategy;
import org.wicketstuff.javaee.naming.StandardJndiNamingStrategy;

public class JavaEEProxyFieldValueFactory
implements IFieldValueFactory {
    private final ConcurrentHashMap<IProxyTargetLocator, Object> cache = new ConcurrentHashMap();
    private final IJndiNamingStrategy namingStrategy;

    public JavaEEProxyFieldValueFactory() {
        this(new StandardJndiNamingStrategy());
    }

    public JavaEEProxyFieldValueFactory(IJndiNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        IProxyTargetLocator locator = this.getProxyTargetLocator(field);
        return this.getCachedProxy(field, locator);
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(EJB.class) || field.isAnnotationPresent(Resource.class) || field.isAnnotationPresent(PersistenceUnit.class);
    }

    private Object getCachedProxy(Field field, IProxyTargetLocator locator) {
        Class<?> type = field.getType();
        if (locator == null) {
            return null;
        }
        if (field.isAnnotationPresent(EJB.class) && field.getAnnotation(EJB.class).description().equals("stateful") || field.getType().isAnnotationPresent(Stateful.class)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest();
            HttpSession session = httpServletRequest.getSession();
            Object retValue = session.getAttribute(type.getName());
            if (retValue == null) {
                retValue = !Modifier.isFinal(type.getModifiers()) ? LazyInitProxyFactory.createProxy(type, (IProxyTargetLocator)locator) : locator.locateProxyTarget();
                session.setAttribute(type.getName(), retValue);
            }
            return retValue;
        }
        if (this.cache.containsKey(locator)) {
            return this.cache.get(locator);
        }
        if (!Modifier.isFinal(type.getModifiers())) {
            Object proxy = LazyInitProxyFactory.createProxy(type, (IProxyTargetLocator)locator);
            this.cache.put(locator, proxy);
            return proxy;
        }
        Object value = locator.locateProxyTarget();
        this.cache.put(locator, value);
        return value;
    }

    private IProxyTargetLocator getProxyTargetLocator(Field field) {
        if (field.isAnnotationPresent(EJB.class)) {
            return new JavaEEBeanLocator(field.getAnnotation(EJB.class).name(), field.getType(), this.namingStrategy);
        }
        if (field.isAnnotationPresent(PersistenceUnit.class)) {
            return new EntityManagerFactoryLocator(field.getAnnotation(PersistenceUnit.class).unitName());
        }
        if (field.isAnnotationPresent(Resource.class)) {
            return new JndiObjectLocator(field.getAnnotation(Resource.class).name(), field.getType());
        }
        return null;
    }
}

