/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jeeweb.jsp;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspUrlTagSupport
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JspUrlTagSupport.class);
    private String page = null;
    private String query = null;

    public int doStartTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            PageParameters pageParameters = new PageParameters();
            if (this.query != null) {
                RequestUtils.decodeParameters((String)this.query, (PageParameters)pageParameters);
            }
            Class resolveClass = WicketObjects.resolveClass((String)this.page);
            CharSequence urlFor = RequestCycle.get().urlFor(resolveClass, pageParameters);
            out.write(urlFor.toString());
            out.flush();
        }
        catch (IOException e) {
            LOGGER.error("Error while generating url for page " + this.page, (Throwable)e);
            throw new JspException("Error while generating url for page ", (Throwable)e);
        }
        return 0;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

