/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jeeweb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEEWebResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final String SERVLET_AND_JSP_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(JEEWebResolver.class);

    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag instanceof WicketTag) {
            WicketTag wtag = (WicketTag)tag;
            if ("jsp".equalsIgnoreCase(wtag.getName())) {
                String file = wtag.getAttributes().getString("file");
                if (file == null || file.trim().length() == 0) {
                    throw new MarkupException("Wrong format of <wicket:jsp file='/foo.jsp'>: attribute 'file' is missing");
                }
                return new ServletAndJspFileContainer(file, Type.JSP);
            }
            if ("jsf".equalsIgnoreCase(wtag.getName())) {
                String file = wtag.getAttributes().getString("file");
                if (file == null || file.trim().length() == 0) {
                    throw new MarkupException("Wrong format of <wicket:jsf file='/foo.xhtml'>: attribute 'file' is missing");
                }
                return new ServletAndJspFileContainer(file, Type.JSF);
            }
            if ("servlet".equalsIgnoreCase(wtag.getName())) {
                String path = wtag.getAttributes().getString("path");
                if (path == null || path.trim().length() == 0) {
                    throw new MarkupException("Wrong format of <wicket:servlet path='/Test'>: attribute 'path' is missing");
                }
                return new ServletAndJspFileContainer(path, Type.SERVLET);
            }
        }
        return null;
    }

    static {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Registering" + JEEWebResolver.class.getName());
        }
        WicketTagIdentifier.registerWellKnownTagName((String)"jsp");
        WicketTagIdentifier.registerWellKnownTagName((String)"jsf");
        WicketTagIdentifier.registerWellKnownTagName((String)"servlet");
    }

    private static enum Type {
        JSP,
        JSF,
        SERVLET;

    }

    private static class JSPIncludeHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        private final ServletOutputStream byteArrayServletOutputStream = new ByteArrayServletOutputStream(this.byteArrayOutputStream);
        private final PrintWriter printWriter = new PrintWriter(this.byteArrayOutputStream);

        public JSPIncludeHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() {
            return this.byteArrayServletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            return this.printWriter;
        }

        public String getOutput() throws UnsupportedEncodingException {
            this.printWriter.flush();
            return this.byteArrayOutputStream.toString(JEEWebResolver.SERVLET_AND_JSP_ENCODING);
        }
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream baos;

        public ByteArrayServletOutputStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int param) throws IOException {
            this.baos.write(param);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    private static class ServletAndJspFileContainer
    extends MarkupContainer {
        private static final long serialVersionUID = -4296125929087527034L;
        private final String resource;
        private final Type type;

        public ServletAndJspFileContainer(String resource, Type type) {
            super(resource);
            this.resource = resource;
            this.type = type;
        }

        protected void onComponentTag(ComponentTag tag) {
            tag.setType(XmlTag.TagType.OPEN);
            super.onComponentTag(tag);
        }

        public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            RequestCycle cycle = this.getRequestCycle();
            HttpServletRequest request = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            JSPIncludeHttpServletResponseWrapper response = new JSPIncludeHttpServletResponseWrapper((HttpServletResponse)cycle.getResponse().getContainerResponse());
            ServletContext context = ((WebApplication)Application.get()).getServletContext();
            this.handleMissingResource(context);
            try {
                context.getRequestDispatcher(this.resource).include((ServletRequest)request, (ServletResponse)response);
                this.replaceComponentTagBody(markupStream, openTag, response.getOutput());
            }
            catch (IOException | ServletException e) {
                throw new WicketRuntimeException(e);
            }
        }

        private void handleMissingResource(ServletContext context) throws WicketRuntimeException {
            try {
                if (this.type == Type.JSP || this.type == Type.JSF) {
                    if (context.getResource(this.resource) == null) {
                        this.promptMissingResource(context, this.type);
                    }
                } else {
                    boolean found = false;
                    Iterator servletRegistrationIterator = context.getServletRegistrations().values().iterator();
                    while (servletRegistrationIterator.hasNext()) {
                        for (String mapping : ((ServletRegistration)servletRegistrationIterator.next()).getMappings()) {
                            if (!this.resource.equals(mapping)) continue;
                            found = true;
                        }
                    }
                    if (!found) {
                        this.promptMissingResource(context, this.type);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }

        private void promptMissingResource(ServletContext context, Type type) {
            if (this.shouldThrowExceptionForMissingFile()) {
                throw new WicketRuntimeException(String.format("Cannot locate resource %s of type: %s within current context: %s", this.resource, type.toString(), context.getContextPath()));
            }
            LOGGER.warn("Resource of type: {} will not be processed. Cannot locate it {} within current context: {}", new Object[]{type.toString(), this.resource, context.getContextPath()});
        }

        private boolean shouldThrowExceptionForMissingFile() {
            return Application.get().getResourceSettings().getThrowExceptionOnMissingResource();
        }
    }
}

