/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jeeweb.ajax;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.WicketAjaxJQueryResourceReference;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jeeweb.ajax.JEEWebGlobalAjaxEvent;

public class JEEWebGlobalAjaxHandler
extends ResourceReference {
    private static final Logger LOGGER = LoggerFactory.getLogger(JEEWebGlobalAjaxHandler.class);
    private static final long serialVersionUID = 4348780269907263872L;

    public JEEWebGlobalAjaxHandler() {
        super(JEEWebGlobalAjaxHandler.class.getSimpleName());
    }

    public IResource getResource() {
        return new IResource(){
            private static final long serialVersionUID = 3070290312369930992L;

            public void respond(IResource.Attributes attributes) {
                try {
                    PageParameters parameters = attributes.getParameters();
                    int pageId = parameters.get("pageId").toInt();
                    Page page = (Page)WebSession.get().getPageManager().getPage(pageId);
                    AjaxRequestTarget newAjaxRequestTarget = ((WebApplication)Application.get()).newAjaxRequestTarget(page);
                    RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)newAjaxRequestTarget);
                    page.send((IEventSink)page, Broadcast.BREADTH, (Object)new JEEWebGlobalAjaxEvent(newAjaxRequestTarget, parameters, RequestCycle.get().getRequest().getPostParameters()));
                }
                catch (Exception e) {
                    LOGGER.error("Error while processing the ajax request", (Throwable)e);
                }
            }
        };
    }

    public static void configure(WebApplication application) {
        application.getRequestCycleListeners().add((Object)new PageRequestHandlerTracker());
        application.mountResource("/" + JEEWebGlobalAjaxHandler.class.getSimpleName(), (ResourceReference)new JEEWebGlobalAjaxHandler());
        application.getHeaderContributorListeners().add((Object)new IHeaderContributor(){
            private static final long serialVersionUID = 1644041155625458328L;

            public void renderHead(IHeaderResponse response) {
                JavaScriptResourceReference forReference = new JavaScriptResourceReference(JEEWebGlobalAjaxHandler.class, JEEWebGlobalAjaxHandler.class.getSimpleName() + ".js"){
                    private static final long serialVersionUID = -3649384632770480975L;

                    public List<HeaderItem> getDependencies() {
                        return new ArrayList<HeaderItem>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add(JavaScriptHeaderItem.forReference((ResourceReference)WicketAjaxJQueryResourceReference.get()));
                            }
                        };
                    }
                };
                response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)forReference));
                this.addAJaxBaseUrl(response);
            }

            private void addAJaxBaseUrl(IHeaderResponse response) {
                Url baseUrl = RequestCycle.get().getUrlRenderer().getBaseUrl();
                CharSequence ajaxBaseUrl = Strings.escapeMarkup((CharSequence)baseUrl.toString());
                response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)("Wicket.Ajax.baseUrl=\"" + ajaxBaseUrl + "\";"), (String)"wicket-ajax-base-url"));
            }
        });
    }
}

