/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery;

import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JQueryBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference JQUERY_JS = new PackageResourceReference(JQueryBehavior.class, "jquery.js");
    public static final ResourceReference JQUERY_DEBUG_JS = new PackageResourceReference(JQueryBehavior.class, "jquery.debug.js");
    public static final ResourceReference INTERFACE_JS = new PackageResourceReference(JQueryBehavior.class, "interface-1.2.js");
    public static final ResourceReference JQUERY_UI_JS = new PackageResourceReference(JQueryBehavior.class, "jquery-ui-personalized.js");
    public static final ResourceReference JQUERY_BGIFRAME_JS = new PackageResourceReference(JQueryBehavior.class, "jquery.bgiframe-2.1.1.js");
    public static final Pattern JQUERY_REGEXP = Pattern.compile(".*\\<.*script.*src=\".*jquery.*\\.js\"\\>.*", 32);
    private transient Logger logger_;

    public void renderHead(Component component, IHeaderResponse response) {
        try {
            CharSequence script;
            super.renderHead(component, response);
            if (this.getIncludeJQueryJS(response)) {
                response.renderJavaScriptReference(JQUERY_JS);
                if (Application.get().usesDevelopmentConfig()) {
                    response.renderJavaScriptReference(JQUERY_DEBUG_JS);
                }
            }
            if ((script = this.getOnReadyScript()) != null && script.length() > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append("<script type=\"text/javascript\">\n$(document).ready(function(){\n");
                builder.append(script);
                builder.append("\n});</script>");
                response.renderString((CharSequence)builder.toString());
            }
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException("wrap: " + exc.getMessage(), exc);
        }
    }

    public boolean getIncludeJQueryJS(IHeaderResponse response) {
        return !JQUERY_REGEXP.matcher(response.getResponse().toString()).matches();
    }

    protected CharSequence getOnReadyScript() {
        return null;
    }

    protected void respond(AjaxRequestTarget target) {
        throw new UnsupportedOperationException("nothing to do");
    }

    protected Logger logger() {
        if (this.logger_ == null) {
            this.logger_ = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger_;
    }
}

