/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.wicketstuff.jquery.FunctionString;

public class Options
implements Serializable {
    protected Map<String, Object> options_ = new HashMap<String, Object>();

    public Object get(String name) {
        return this.options_.get(name);
    }

    public Object get(String name, Object defaultValue) {
        Object back = this.options_.get(name);
        if (back == null) {
            back = defaultValue;
        }
        return back;
    }

    public Options set(String name, Object value) {
        return this.set(name, value, true);
    }

    public Options set(String name, Object value, boolean overwrite) {
        if (!overwrite && this.options_.containsKey(name)) {
            return this;
        }
        if (value == null && this.options_.containsKey(name)) {
            this.options_.remove(name);
        }
        this.options_.put(name, value);
        return this;
    }

    public String toString() {
        return ((Object)this.toString(false)).toString();
    }

    public CharSequence toString(boolean asFragment) {
        if (this.options_.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        if (!asFragment) {
            str.append("{\n");
        }
        for (Map.Entry<String, Object> entry : this.options_.entrySet()) {
            str.append("\t'").append(this.escape(entry.getKey())).append("':");
            Object val = entry.getValue();
            if (val instanceof FunctionString) {
                str.append(val.toString());
            } else if (val instanceof Boolean || val instanceof Number) {
                str.append(val.toString());
            } else {
                str.append("'" + this.escape(val.toString()) + "'");
            }
            str.append(",\n");
        }
        if (!asFragment) {
            str.setLength(str.length() - 2);
            str.append("\n}\n");
        }
        return str;
    }

    private String escape(String input) {
        StringBuilder output = new StringBuilder();
        for (char ch : input.toCharArray()) {
            if (ch == '\'') {
                output.append('\\');
            }
            output.append(ch);
        }
        return output.toString();
    }
}

