/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ajaxbackbutton;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;
import org.wicketstuff.jquery.JQueryBehavior;

public abstract class HistoryAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String HISTORY_ITEM_PARAM = "hiId";

    public final CharSequence getCallbackUrl() {
        return super.getCallbackUrl() + "&" + HISTORY_ITEM_PARAM + "=' + HistoryManager.getHistoryItem()";
    }

    public void renderHead(Component component, IHeaderResponse response) {
        response.renderCSSReference((ResourceReference)new PackageResourceReference(HistoryAjaxBehavior.class, "res/history-manager-iframe.css"));
        response.renderJavaScriptReference(JQueryBehavior.JQUERY_JS);
        response.renderJavaScriptReference((ResourceReference)new PackageResourceReference(HistoryAjaxBehavior.class, "res/history-manager.js"));
        response.renderJavaScript((CharSequence)("var notifyBackButton = function() { wicketAjaxGet('" + this.getCallbackUrl() + ", null, null, function() {return true;}.bind(this)); }"), "history-manager-url");
    }

    protected void respond(AjaxRequestTarget target) {
        StringValue componentId = RequestCycle.get().getRequest().getQueryParameters().getParameterValue(HISTORY_ITEM_PARAM);
        this.onAjaxHistoryEvent(target, componentId.toString());
    }

    public abstract void onAjaxHistoryEvent(AjaxRequestTarget var1, String var2);

    public void registerAjaxEvent(AjaxRequestTarget target, Component component) {
        if (RequestCycle.get().getRequest().getQueryParameters().getParameterValue(HISTORY_ITEM_PARAM).isNull()) {
            target.appendJavaScript((CharSequence)("HistoryManager.addHistoryEntry('" + component.getId() + "');"));
        }
    }
}

