/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.block;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.block.BlockOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockingAjaxLink<T>
extends AjaxLink<T> {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference BLOCK_JS = new PackageResourceReference(BlockingAjaxLink.class, "jquery.blockUI.js");
    final BlockOptions options;

    public BlockingAjaxLink(String id, BlockOptions options) {
        super(id, null);
        this.options = options;
    }

    public BlockingAjaxLink(String id, String message) {
        this(id, new BlockOptions().setMessage(message));
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavaScriptReference(JQueryBehavior.JQUERY_JS);
        response.renderJavaScriptReference(BLOCK_JS);
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return new IAjaxCallDecorator(){
            private static final long serialVersionUID = 1L;

            public CharSequence decorateScript(Component component, CharSequence script) {
                StringBuilder js = new StringBuilder();
                CharSequence sel = BlockingAjaxLink.this.getBlockElementsSelector();
                if (sel != null) {
                    js.append("$('").append(sel).append("').block( ");
                } else {
                    js.append("$.blockUI( ");
                }
                return js.append(BlockingAjaxLink.this.options.toString()).append(" ); ").append(script);
            }

            public CharSequence decorateOnSuccessScript(Component component, CharSequence script) {
                return script;
            }

            public CharSequence decorateOnFailureScript(Component component, CharSequence script) {
                return script;
            }
        };
    }

    public CharSequence getBlockElementsSelector() {
        return null;
    }

    public final void onClick(AjaxRequestTarget target) {
        this.doClick(target);
        CharSequence sel = this.getBlockElementsSelector();
        if (sel != null) {
            target.appendJavaScript((CharSequence)("$('" + sel + "').unblock(); "));
        } else {
            target.appendJavaScript((CharSequence)"$.unblockUI(); ");
        }
    }

    public abstract void doClick(AjaxRequestTarget var1);
}

