/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.codepress;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.codepress.CodepressOptions;
import org.wicketstuff.minis.behavior.SimpleAttributeAppender;

public class CodepressBehaviour
extends JQueryBehavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference CODEPRESS_JS = new PackageResourceReference(CodepressBehaviour.class, "jquery.codepress.js");
    private final CodepressOptions options_;

    public CodepressBehaviour() {
        this(new CodepressOptions());
    }

    public CodepressBehaviour(CodepressOptions options) {
        this.options_ = options != null ? options : new CodepressOptions();
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderJavaScriptReference(CODEPRESS_JS);
    }

    protected CharSequence getOnReadyScript() {
        StringBuilder onReady = new StringBuilder("$.codepress.config = ");
        onReady.append(this.options_.toString(false));
        onReady.append("$('" + this.getComponent().getMarkupId() + "').codepress();");
        return onReady;
    }

    protected void onBind() {
        super.onBind();
        StringBuilder classes = new StringBuilder("codepress");
        if (this.options_.getFileType() != null) {
            classes.append(" " + this.options_.getFileType());
        }
        classes.append(" autocomplete-" + (this.options_.isAutoComplete() ? "on" : "off"));
        if (!this.options_.isLineNumbers()) {
            classes.append(" linenumbers-off");
        }
        this.getComponent().add(new Behavior[]{new SimpleAttributeAppender("class", (CharSequence)classes.toString(), (CharSequence)" ")});
    }
}

