/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.crop;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.FunctionString;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.crop.CropOptions;

public class CropBehaviour
extends JQueryBehavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference IRESIZABLE_JS = new PackageResourceReference(CropBehaviour.class, "iresizable.js");
    public static final ResourceReference IUTIL_JS = new PackageResourceReference(CropBehaviour.class, "iutil.js");
    public static final ResourceReference CROP_BG = new PackageResourceReference(CropBehaviour.class, "crop_bg.png");
    private CropOptions options;

    public CropBehaviour() {
        this(new CropOptions());
    }

    public CropBehaviour(CropOptions options) {
        this.options = options != null ? options : new CropOptions();
    }

    protected CharSequence getOnReadyScript() {
        StringBuilder onReady = new StringBuilder("$('#" + this.getComponent().getMarkupId() + "').Resizable(");
        this.options.set("onStop", new FunctionString("cropCallback"));
        this.options.set("onDragStop", new FunctionString("cropCallback"));
        this.options.set("onResize", new FunctionString("function(size, position) {\n this.style.backgroundPosition = '-' + (position.left) + 'px -' + (position.top) + 'px'; \n}\n"));
        this.options.set("onDrag", new FunctionString("function(x, y) {\n this.style.backgroundPosition = '-' + (x) + 'px -' + (y) + 'px'; \n}\n"));
        this.options.set("handlers", new FunctionString("{ se: '#resizeSE', e: '#resizeE', ne: '#resizeNE', n: '#resizeN', nw: '#resizeNW', w: '#resizeW', sw: '#resizeSW', s: '#resizeS' }\n"));
        onReady.append(this.options.toString(false));
        onReady.append(");");
        return onReady;
    }

    protected CharSequence getCallbackScript() {
        String c = "$('#" + this.getComponent().getMarkupId() + "')";
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&width=' + " + c + ".width() + '" + "&height=' + " + c + ".height() + '" + "&top=' + " + c + ".css('top') + '" + "&left=' + " + c + ".css('left')");
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderJavaScriptReference(JQUERY_JS);
        response.renderJavaScriptReference(INTERFACE_JS);
        response.renderJavaScriptReference(IRESIZABLE_JS);
        response.renderJavaScriptReference(IUTIL_JS);
        response.renderJavaScript((CharSequence)("function cropCallback() {\n" + this.getCallbackScript() + "\n}\n"), "crop-init-for-" + this.getComponent().getMarkupId());
    }

    protected void respond(AjaxRequestTarget target) {
        Request req = RequestCycle.get().getRequest();
        this.onCropped(target, req.getQueryParameters().getParameterValue("width").toInt(), req.getQueryParameters().getParameterValue("height").toInt(), Integer.parseInt(req.getQueryParameters().getParameterValue("top").toString().replace("px", "")), Integer.parseInt(req.getQueryParameters().getParameterValue("left").toString().replace("px", "")));
    }

    public void onCropped(AjaxRequestTarget target, int width, int height, int top, int left) {
        System.out.println("Height: " + height);
        System.out.println("Width: " + width);
        System.out.println("Top: " + top);
        System.out.println("Left: " + left);
    }
}

