/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.crop;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.wicketstuff.jquery.crop.CropBehaviour;

public class CroppableImage
extends Panel {
    private static final long serialVersionUID = 1L;
    private WebMarkupContainer container = new WebMarkupContainer("container");
    private WebMarkupContainer image;
    private final Map<String, Object> vars;

    public CroppableImage(String id, CropBehaviour behaviour, String imageUrl, int width, int height) {
        super(id);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.image = new WebMarkupContainer("image");
        this.image.setOutputMarkupId(true);
        this.add(new Component[]{this.image});
        this.vars = new HashMap<String, Object>();
        this.vars.put("container", this.container.getMarkupId());
        this.vars.put("image", this.image.getMarkupId());
        this.vars.put("imageUrl", imageUrl);
        this.vars.put("width", width);
        this.vars.put("height", height);
        this.vars.put("rwidth", width / 2);
        this.vars.put("rheight", height / 2);
        this.vars.put("cropBg", this.urlFor(CropBehaviour.CROP_BG, null));
        this.image.add(new Behavior[]{behaviour});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        PackageTextTemplate template = new PackageTextTemplate(CroppableImage.class, "crop.css");
        String css = template.interpolate(this.vars).asString();
        response.renderCSS((CharSequence)css, "croppable-image." + this.getMarkupId());
    }
}

