/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.datepicker;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.datepicker.DatePickerOptions;
import org.wicketstuff.minis.behavior.CompositeBehavior;
import org.wicketstuff.minis.behavior.SimpleAttributeAppender;

public class DatePickerBehavior
extends JQueryBehavior {
    public static final ResourceReference DATE_JS = new PackageResourceReference(DatePickerBehavior.class, "date.js");
    public static final ResourceReference JQUERY_DATEPICKER_JS = new PackageResourceReference(DatePickerBehavior.class, "jquery.datePicker.js");
    public static final ResourceReference DATEPICKER_CSS = new PackageResourceReference(DatePickerBehavior.class, "datePicker.css");
    private final DatePickerOptions options_;
    private String format_;
    private boolean includeJquery = true;

    public boolean isIncludeJquery() {
        return this.includeJquery;
    }

    public void setIncludeJquery(boolean includeJquery) {
        this.includeJquery = includeJquery;
    }

    public DatePickerBehavior() {
        this(null);
    }

    public DatePickerBehavior(DatePickerOptions options) {
        if (options == null) {
            options = new DatePickerOptions();
        }
        this.options_ = options;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        if (this.includeJquery) {
            super.renderHead(component, response);
        }
        response.renderCSSReference(DATEPICKER_CSS);
        response.renderJavaScriptReference(DATE_JS);
        try {
            WebClientInfo info = WebSession.get().getClientInfo();
            if (info.getUserAgent().contains("MSIE")) {
                response.renderJavaScriptReference(JQUERY_BGIFRAME_JS);
            }
        }
        catch (ClassCastException exc) {
            this.logger().info("can't find info about client", (Throwable)exc);
        }
        response.renderJavaScriptReference(JQUERY_DATEPICKER_JS);
        if (this.options_.dynamicLocalizedMessages) {
            int i;
            HashMap<String, StringBuilder> lm = new HashMap<String, StringBuilder>();
            SimpleDateFormat sdf = new SimpleDateFormat("", this.getComponent().getLocale());
            lm.put("dayNames", new StringBuilder("Date.dayNames = ["));
            lm.put("abbrDayNames", new StringBuilder("Date.abbrDayNames = ["));
            lm.put("monthNames", new StringBuilder("Date.monthNames = ["));
            lm.put("abbrMonthNames", new StringBuilder("Date.abbrMonthNames = ["));
            for (i = 1; i < 8; ++i) {
                ((StringBuilder)lm.get("dayNames")).append(" '" + Strings.capitalize((String)sdf.getDateFormatSymbols().getWeekdays()[i]));
                ((StringBuilder)lm.get("abbrDayNames")).append(" '" + Strings.capitalize((String)sdf.getDateFormatSymbols().getShortWeekdays()[i]));
                if (i >= 7) continue;
                ((StringBuilder)lm.get("dayNames")).append("',");
                ((StringBuilder)lm.get("abbrDayNames")).append("',");
            }
            for (i = 0; i < 12; ++i) {
                ((StringBuilder)lm.get("monthNames")).append(" '" + Strings.capitalize((String)sdf.getDateFormatSymbols().getMonths()[i]));
                ((StringBuilder)lm.get("abbrMonthNames")).append(" '" + Strings.capitalize((String)sdf.getDateFormatSymbols().getShortMonths()[i]));
                if (i >= 11) continue;
                ((StringBuilder)lm.get("monthNames")).append("',");
                ((StringBuilder)lm.get("abbrMonthNames")).append("',");
            }
            String locMess = ((StringBuilder)lm.get("dayNames")).toString() + "' ];\n" + lm.get("abbrDayNames") + "' ];\n" + lm.get("monthNames") + "' ];\n" + lm.get("abbrMonthNames") + "' ];\n";
            response.renderJavaScript((CharSequence)locMess, "localization_override" + this.getComponent().getMarkupId());
        }
    }

    protected CharSequence getOnReadyScript() {
        String selector = ".date-pick";
        Component component = this.getComponent();
        if (!(component instanceof Page)) {
            selector = "#" + component.getMarkupId();
        }
        return String.format("Date.format = '%s';$('%s').datePicker(%s)", this.format_, selector, this.options_.toString(false));
    }

    protected void onBind() {
        super.onBind();
        Component component = this.getComponent();
        if (component instanceof TextField) {
            component.setOutputMarkupId(true);
            if (component instanceof AbstractTextComponent.ITextFormatProvider) {
                this.format_ = ((AbstractTextComponent.ITextFormatProvider)component).getTextFormat().toLowerCase();
            } else {
                TextField tf = (TextField)component;
                IConverter cnv = tf.getConverter(tf.getType());
                if (cnv != null && DateConverter.class.isAssignableFrom(cnv.getClass())) {
                    SimpleDateFormat sdf = (SimpleDateFormat)((DateConverter)cnv).getDateFormat(component.getLocale());
                    this.format_ = sdf.toPattern().toLowerCase();
                }
            }
        } else {
            throw new RuntimeException("DatePicketBehavior is intended to be attached to a TextField component!");
        }
        component.add(new Behavior[]{this.getDatePickerStyle()});
    }

    public Behavior getDatePickerStyle() {
        return new CompositeBehavior(new Behavior[]{new SimpleAttributeAppender("class", (CharSequence)"date-pick", (CharSequence)" "), AttributeModifier.replace((String)"size", (Serializable)((Object)String.valueOf(this.format_.length()))), AttributeModifier.replace((String)"maxlength", (Serializable)((Object)String.valueOf(this.format_.length()))), AttributeModifier.replace((String)"title", (Serializable)((Object)this.format_))});
    }
}

