/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.dnd;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.jquery.FunctionString;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.Options;

public class DnDBehaviour
extends JQueryBehavior
implements IBehaviorListener {
    private static final long serialVersionUID = 1L;
    private Options droppableOptions;
    private Options draggableOptions;
    private String dropSelector;
    private String dragSelector;

    public DnDBehaviour() {
    }

    public DnDBehaviour(Options draggableOptions, Options droppableOptions, String dragSelector, String dropSelector) {
        this.dropSelector = dropSelector;
        this.dragSelector = dragSelector;
        this.draggableOptions = draggableOptions;
        this.droppableOptions = droppableOptions;
    }

    public DnDBehaviour(String dragSelector, String dropSelector) {
        this(new Options(), new Options(), dragSelector, dropSelector);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        this.droppableOptions.set("accept", this.dragSelector, false);
        this.droppableOptions.set("drop", new FunctionString(this.getDropScript()));
        response.renderJavaScriptReference(JQueryBehavior.JQUERY_UI_JS);
        super.renderHead(component, response);
    }

    public String getDropScript() {
        return "function(ev, ui) {\n " + this.getCallbackScript() + "\n}\n";
    }

    public final void respond(AjaxRequestTarget target) {
        Request req = RequestCycle.get().getRequest();
        this.onDrop(req.getQueryParameters().getParameterValue("src").toString(), req.getQueryParameters().getParameterValue("dest").toString(), target);
    }

    protected CharSequence getCallbackScript() {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&src=' + $(ui.draggable).attr('id') + '" + "&dest=' + $(this).attr('id')");
    }

    public void onDrop(String srcId, String destId, AjaxRequestTarget target) {
    }

    protected CharSequence getOnReadyScript() {
        return this.getRebindScript();
    }

    public String getRebindScript() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t$('" + this.dragSelector + "').draggable(" + this.draggableOptions.toString(false) + ");\n");
        sb.append("\t$('" + this.dropSelector + "').addClass('droppable-active').droppable(" + this.droppableOptions.toString(false) + ");\n");
        return sb.toString();
    }
}

