/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.dnd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.Options;

public class DnDSortableBehavior
extends JQueryBehavior
implements IBehaviorListener {
    public static final ResourceReference DNDSORTABLEBEHAVIOR_JS = new PackageResourceReference(DnDSortableBehavior.class, DnDSortableBehavior.class.getSimpleName() + ".js");
    protected Options options_;
    protected ArrayList<MarkupContainer> containers_;

    public DnDSortableBehavior() {
        this(null);
    }

    public DnDSortableBehavior(Options options) {
        if (options == null) {
            options = new Options();
        }
        this.options_ = options;
        this.options_.set("accept", "dndItem", false).set("helperclass", "sortHelper", false).set("activeclass", "sortableactive", false).set("hoverclass", "sortablehover", false).set("tolerance", "pointer", false).set("startOnLoad", Boolean.TRUE, false);
        this.containers_ = new ArrayList();
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderJavaScriptReference(INTERFACE_JS);
        response.renderJavaScriptReference(DNDSORTABLEBEHAVIOR_JS);
        response.renderString(this.getHead(false));
    }

    public CharSequence getRebindScript() {
        return this.getHead(true);
    }

    private CharSequence getHead(boolean rebind) {
        PackageTextTemplate template = new PackageTextTemplate(DnDSortableBehavior.class, DnDSortableBehavior.class.getSimpleName() + (rebind ? "-rebind.tmpl" : "-head.tmpl"));
        String itemSelector = "." + this.options_.get("accept");
        CharSequence handleSelector = (CharSequence)this.options_.get("handle");
        if (handleSelector == null) {
            handleSelector = itemSelector;
        }
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("containerSelector", "." + this.getContainerCSSClass());
        params.put("helperclass", this.options_.get("helperclass", "").toString());
        params.put("handleSelector", handleSelector);
        params.put("itemSelector", itemSelector);
        params.put("options", this.options_.toString(true));
        params.put("callbackUrl", this.getCallbackUrl());
        params.put("dndHandlerStart", this.getJSFunctionName4Start());
        params.put("dndHandlerStop", this.getJSFunctionName4Stop());
        return template.asString(params);
    }

    private CharSequence getContainerCSSClass() {
        CharSequence back = (CharSequence)this.options_.get("containerclass", null);
        if (back == null) {
            back = this.getComponent().getId() + "_dndContainer";
        }
        return back;
    }

    public String getOnReadyScript() {
        return "$( " + this.getJSFunctionName4Start() + " );";
    }

    public CharSequence getJSFunctionName4Start() {
        return this.getComponent().getId() + "_dndStart";
    }

    public CharSequence getJSFunctionName4Stop() {
        return this.getComponent().getId() + "_dndStop";
    }

    public final void respond(AjaxRequestTarget target) {
        try {
            Request req = RequestCycle.get().getRequest();
            if (this.logger().isDebugEnabled()) {
                this.logger().debug("params : {}", (Object)req.getRequestParameters());
            }
            this.onDnD(target, req.getQueryParameters().getParameterValue("srcContainerId").toString(), req.getQueryParameters().getParameterValue("srcPosition").toInt(), req.getQueryParameters().getParameterValue("destContainerId").toString(), req.getQueryParameters().getParameterValue("destPosition").toInt());
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException("wrap: " + exc.getMessage(), exc);
        }
    }

    public void onDnD(AjaxRequestTarget target, String srcContainerId, int srcPos, String destContainerId, int destPos) {
        boolean updateContainers;
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("srcContainerId={}, srcPos={}, destContainerId={}, destPos={}", new Object[]{srcContainerId, srcPos, destContainerId, destPos});
        }
        MarkupContainer srcContainer = null;
        MarkupContainer destContainer = null;
        for (MarkupContainer container : this.containers_) {
            if (srcContainerId != null && srcContainerId.equals(container.getMarkupId())) {
                srcContainer = container;
            }
            if (destContainerId != null && destContainerId.equals(container.getMarkupId())) {
                destContainer = container;
            }
            if (srcContainer == null || destContainer == null) continue;
            break;
        }
        if ((updateContainers = this.onDnD(target, srcContainer, srcPos, destContainer, destPos)) && target != null) {
            target.add(new Component[]{srcContainer});
            if (srcContainer != destContainer) {
                target.add(new Component[]{destContainer});
            }
            target.appendJavaScript((CharSequence)(this.getJSFunctionName4Start() + "();"));
        }
    }

    public boolean onDnD(AjaxRequestTarget target, MarkupContainer srcContainer, int srcPos, MarkupContainer destContainer, int destPos) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("srcContainer={}, srcPos={}, destContainer={}, destPos={}", new Object[]{srcContainer, srcPos, destContainer, destPos});
        }
        return false;
    }

    protected DnDSortableBehavior registerContainer(MarkupContainer v) {
        v.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)String.valueOf(this.getContainerCSSClass()))), " ")});
        v.setOutputMarkupId(true);
        this.containers_.add(v);
        return this;
    }

    protected DnDSortableBehavior registerItem(Component v) {
        v.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)String.valueOf(this.options_.get("accept")))), " ")});
        v.setOutputMarkupId(true);
        return this;
    }
}

