/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.jgrowl;

import org.apache.wicket.IClusterable;
import org.apache.wicket.feedback.FeedbackMessage;
import org.wicketstuff.jquery.Options;

public class JGrowlFeedbackMessage
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final String message;
    private final Options options;

    public JGrowlFeedbackMessage(FeedbackMessage feedbackMessage) {
        this.message = feedbackMessage.getMessage().toString();
        switch (feedbackMessage.getLevel()) {
            case 400: {
                this.options = this.newErrorOptions();
                break;
            }
            case 500: {
                this.options = this.newFatalOptions();
                break;
            }
            case 100: {
                this.options = this.newDebugOptions();
                break;
            }
            case 300: {
                this.options = this.newWarningOptions();
                break;
            }
            case 200: {
                this.options = this.newInfoOptions();
                break;
            }
            default: {
                this.options = new Options();
            }
        }
    }

    protected Options newFatalOptions() {
        return new Options();
    }

    protected Options newDebugOptions() {
        return new Options();
    }

    protected Options newWarningOptions() {
        return new Options();
    }

    protected Options newInfoOptions() {
        Options infoOptions = new Options();
        return infoOptions;
    }

    protected Options newErrorOptions() {
        return new Options();
    }

    public String toJavaScript() {
        StringBuilder javaScript = new StringBuilder();
        javaScript.append("$.jGrowl(\"");
        javaScript.append(this.message);
        javaScript.append("\"");
        if (this.options != null) {
            javaScript.append(", ");
            javaScript.append(this.options.toString());
        }
        javaScript.append(");");
        return javaScript.toString();
    }
}

