/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.jgrowl;

import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.Options;
import org.wicketstuff.jquery.jgrowl.JGrowlFeedbackMessage;

public class JGrowlFeedbackPanel
extends FeedbackPanel {
    private static final long serialVersionUID = 1L;
    private Options errorOptions;
    private Options warningOptions;
    private Options fatalOptions;
    private Options infoOptions;
    private Options debugOptions;

    public JGrowlFeedbackPanel(String id) {
        this(id, null);
    }

    public JGrowlFeedbackPanel(String id, IFeedbackMessageFilter filter) {
        super(id, filter);
        this.setOutputMarkupId(true);
        this.setEscapeModelStrings(false);
    }

    protected Component newMessageDisplayComponent(String id, FeedbackMessage message) {
        JGrowlFeedbackMessage jgrowlFeedbackMessage = new JGrowlFeedbackMessage(message){
            private static final long serialVersionUID = 1L;

            protected Options newFatalOptions() {
                return JGrowlFeedbackPanel.this.fatalOptions;
            }

            protected Options newErrorOptions() {
                return JGrowlFeedbackPanel.this.errorOptions;
            }

            protected Options newWarningOptions() {
                return JGrowlFeedbackPanel.this.warningOptions;
            }

            protected Options newInfoOptions() {
                return JGrowlFeedbackPanel.this.infoOptions;
            }

            protected Options newDebugOptions() {
                return JGrowlFeedbackPanel.this.debugOptions;
            }
        };
        String jgrowlJavaScript = jgrowlFeedbackMessage.toJavaScript();
        Label label = new Label(id, jgrowlJavaScript);
        label.setEscapeModelStrings(this.getEscapeModelStrings());
        return label;
    }

    public void renderHead(IHeaderResponse response) {
        response.renderCSSReference((ResourceReference)new PackageResourceReference(JGrowlFeedbackPanel.class, "res/jquery.jgrowl.css"));
        response.renderJavaScriptReference(JQueryBehavior.JQUERY_JS);
        response.renderJavaScriptReference((ResourceReference)new PackageResourceReference(JGrowlFeedbackPanel.class, "res/jquery.jgrowl.js"));
    }

    public JGrowlFeedbackPanel setErrorMessageOptions(Options errorOptions) {
        this.errorOptions = errorOptions;
        return this;
    }

    public JGrowlFeedbackPanel setFatalMessageOptions(Options fatalOptions) {
        this.fatalOptions = fatalOptions;
        return this;
    }

    public JGrowlFeedbackPanel setWarningMessageOptions(Options warningOptions) {
        this.warningOptions = warningOptions;
        return this;
    }

    public JGrowlFeedbackPanel setInfoMessageOptions(Options infoOptions) {
        this.infoOptions = infoOptions;
        return this;
    }

    public JGrowlFeedbackPanel setDebugMessageOptions(Options debugOptions) {
        this.debugOptions = debugOptions;
        return this;
    }
}

