/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.lightbox;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.lightbox.LightboxOptions;

public class LightboxBehaviour
extends JQueryBehavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference LIGHTBOX_JS = new PackageResourceReference(LightboxBehaviour.class, "jquery.lightbox-0.5.js");
    private static final ResourceReference LIGHTBOX_CSS = new PackageResourceReference(LightboxBehaviour.class, "jquery.lightbox-0.5.css");
    private LightboxOptions options = new LightboxOptions();
    private String selector = "li a";

    public LightboxBehaviour() {
    }

    public LightboxBehaviour(String selector) {
        this();
        this.selector = selector;
    }

    public LightboxOptions getOptions() {
        return this.options;
    }

    protected CharSequence getOnReadyScript() {
        return "\t$('#" + this.getComponent().getMarkupId() + this.getSelector() + "').lightBox(" + this.options.toString(false) + ");";
    }

    public String getSelector() {
        return " " + this.selector;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderJavaScriptReference(this.getLightboxJs());
        response.renderCSSReference(this.getLightboxCss());
    }

    protected void onBind() {
        this.getComponent().setOutputMarkupId(true);
    }

    private ResourceReference getLightboxJs() {
        return LIGHTBOX_JS;
    }

    public ResourceReference getLightboxCss() {
        return LIGHTBOX_CSS;
    }
}

