/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.resize;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.jquery.FunctionString;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.resize.ResizeOptions;

public class ResizeBehaviour
extends JQueryBehavior {
    private static final long serialVersionUID = 1L;
    private ResizeOptions options;

    public ResizeBehaviour() {
        this(new ResizeOptions());
    }

    public ResizeBehaviour(ResizeOptions options) {
        this.options = options != null ? options : new ResizeOptions();
    }

    protected CharSequence getOnReadyScript() {
        StringBuilder onReady = new StringBuilder("$('#" + this.getComponent().getMarkupId() + "').resizable(");
        this.options.set("stop", new FunctionString("function() {\n " + this.getCallbackScript() + "}\n"));
        onReady.append(this.options.toString(false));
        onReady.append(");");
        return onReady;
    }

    protected CharSequence getCallbackScript() {
        String mid = this.getComponent().getMarkupId();
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&height=' + $('#" + mid + "').height() + '" + "&width=' + $('#" + mid + "').width()");
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderJavaScriptReference(JQueryBehavior.JQUERY_UI_JS);
    }

    protected void respond(AjaxRequestTarget target) {
        Request req = RequestCycle.get().getRequest();
        this.onResizeStop(target, req.getQueryParameters().getParameterValue("height").toInt(), req.getQueryParameters().getParameterValue("width").toInt());
    }

    public void onResizeStop(AjaxRequestTarget target, int height, int width) {
    }
}

