/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.sparkline;

import java.util.Collection;
import java.util.Iterator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.sparkline.SparklineOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sparkline
extends WebComponent {
    private static final long serialVersionUID = 1L;
    public static final PackageResourceReference SPARKLINE_JS = new PackageResourceReference(Sparkline.class, "jquery.sparkline-1.4.3.min.js");
    final SparklineOptions options;
    final IModel<Collection<Integer>> model;
    final CharSequence values;
    boolean writeJSOnReady = true;

    public Sparkline(String id, IModel<Collection<Integer>> values, SparklineOptions options) {
        super(id);
        this.setOutputMarkupId(true);
        this.model = values;
        this.values = null;
        this.options = options;
    }

    public Sparkline(String id, Collection<Integer> values, SparklineOptions options) {
        super(id);
        this.setOutputMarkupId(true);
        this.model = null;
        this.values = values.toString();
        this.options = options;
    }

    public Sparkline(String id, SparklineOptions options, int ... values) {
        super(id);
        this.setOutputMarkupId(true);
        this.model = null;
        this.options = options;
        StringBuilder v = new StringBuilder();
        v.append('[');
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                v.append(',');
            }
            v.append(values[i]);
        }
        v.append(']');
        this.values = v;
    }

    public Sparkline(String id, int ... values) {
        this(id, null, values);
    }

    public boolean isWriteJSOnReady() {
        return this.writeJSOnReady;
    }

    public Sparkline setWriteJSOnReady(boolean writeJSOnReady) {
        this.writeJSOnReady = writeJSOnReady;
        return this;
    }

    public CharSequence getSparklineJS() {
        StringBuilder js = new StringBuilder();
        js.append("$('#").append(this.getMarkupId()).append("' ).sparkline( ");
        if (this.model != null) {
            Collection vals = (Collection)this.model.getObject();
            js.append('[');
            Iterator iter = vals.iterator();
            while (iter.hasNext()) {
                js.append(iter.next());
                if (!iter.hasNext()) continue;
                js.append(',');
            }
            js.append(']');
        } else {
            js.append(this.values);
        }
        if (this.options != null) {
            js.append(", ").append(this.options.toString(false));
        }
        js.append(" );");
        return js;
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavaScriptReference(JQueryBehavior.JQUERY_JS);
        response.renderJavaScriptReference((ResourceReference)SPARKLINE_JS);
        if (this.writeJSOnReady) {
            StringBuilder builder = new StringBuilder();
            builder.append("$(document).ready(function(){\n");
            builder.append(this.getSparklineJS());
            builder.append("\n});");
            response.renderJavaScript((CharSequence)builder, null);
        }
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, "sparkline");
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }
}

