/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.tabs;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.JQueryBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JQTabbedPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String TAB_PANEL_ID = "panel";
    private String options;

    public JQTabbedPanel(String id, List<ITab> tabs) {
        this(id, tabs, "");
    }

    public JQTabbedPanel(String id, List<ITab> tabs, String options) {
        super(id);
        this.options = options == null ? "" : options;
        this.add(new Behavior[]{new JQueryBehavior()});
        final WebMarkupContainer parent = new WebMarkupContainer("tabs");
        parent.setOutputMarkupId(true);
        this.add(new Component[]{parent});
        this.add(new Component[]{new Label("script", (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return "$('#" + parent.getMarkupId() + "').tabs(" + JQTabbedPanel.this.getTabsOptions() + ");";
            }
        }).setEscapeModelStrings(false)});
        RepeatingView titles = new RepeatingView("tab");
        parent.add(new Component[]{titles});
        RepeatingView contents = new RepeatingView("content");
        parent.add(new Component[]{contents});
        for (int i = 0; i < tabs.size(); ++i) {
            final WebMarkupContainer content = tabs.get(i).getPanel(TAB_PANEL_ID + i);
            content.setOutputMarkupId(true);
            contents.add(new Component[]{content});
            WebMarkupContainer title = new WebMarkupContainer("panel-title" + i);
            title.setOutputMarkupId(true);
            title.add(new Component[]{new AbstractLink("link"){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("href", (CharSequence)("#" + content.getMarkupId()));
                }
            }.add(new Component[]{new Label("title", tabs.get(i).getTitle())})});
            titles.add(new Component[]{title});
        }
    }

    protected String getTabsOptions() {
        return this.options;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderCSSReference((ResourceReference)new PackageResourceReference(JQTabbedPanel.class, "jquery.tabs.css"));
        response.renderJavaScriptReference((ResourceReference)new PackageResourceReference(JQTabbedPanel.class, "jquery.tabs.pack.js"));
    }
}

