/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.slider;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.JQueryBehavior;
import org.wicketstuff.jquery.ui.UIResources;
import org.wicketstuff.jquery.ui.slider.Slider;
import org.wicketstuff.jquery.ui.slider.SliderOptions;

public class SliderBehavior
extends JQueryBehavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference UI_SLIDER_RESOURCE_REFERENCE = new PackageResourceReference(SliderBehavior.class, "ui.slider.js");
    public static final ResourceReference WICKET_SLIDER_JS = new PackageResourceReference(SliderBehavior.class, "wicket-jquery.slider.js");

    protected CharSequence getOnReadyScript() {
        SliderOptions sliderOptions = this.getSlider().getOptions();
        if (sliderOptions.getOnChange() == null) {
            String body = this.getCallbackScript();
            sliderOptions.setOnChange(body, "e", "ui");
        }
        StringBuilder onReady = new StringBuilder("$('#" + this.getSlider().getMarkupId() + "').slider(");
        onReady.append(sliderOptions.toJSON());
        onReady.append(");\n");
        return onReady;
    }

    protected String getCallbackScript() {
        return ((Object)this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&handleId=' + getHandleId(e, ui) + '&value=' + getValue(e, ui)")).toString();
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderCSSReference(UIResources.FLORA_CSS);
        response.renderCSSReference(UIResources.FLORA_SLIDER_CSS);
        response.renderJavaScriptReference(JQUERY_UI_JS);
        response.renderJavaScriptReference(UI_SLIDER_RESOURCE_REFERENCE);
        response.renderJavaScriptReference(WICKET_SLIDER_JS);
    }

    protected void respond(AjaxRequestTarget target) {
        Request req = RequestCycle.get().getRequest();
        String handleId = req.getQueryParameters().getParameterValue("handleId").toString();
        int newValue = req.getQueryParameters().getParameterValue("value").toInt(-1);
        this.getSlider().onChange(target, handleId, newValue);
    }

    public Slider getSlider() {
        return (Slider)this.getComponent();
    }
}

