/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.slider;

import net.sf.json.JSONArray;
import net.sf.json.JSONFunction;
import net.sf.json.JSONObject;
import org.apache.wicket.IClusterable;
import org.wicketstuff.jquery.ui.slider.SliderHandleOptions;

public class SliderOptions
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final String HANDLES = "handles";
    private static final String CHANGE = "change";
    private static final String RANGE = "range";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String STEPPING = "stepping";
    private static final String ANIMATE = "animate";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String SLIDE = "slide";
    private final transient JSONObject json = new JSONObject();

    public SliderOptions setStepping(Integer stepping) {
        this.json.put((Object)STEPPING, (Object)stepping);
        return this;
    }

    public Integer getStepping() {
        return (Integer)this.json.get(STEPPING);
    }

    public SliderOptions setMin(Integer min) {
        this.json.put((Object)MIN, (Object)min);
        return this;
    }

    public Integer getMin() {
        return (Integer)this.json.get(MIN);
    }

    public SliderOptions setMax(Integer max) {
        this.json.put((Object)MAX, (Object)max);
        return this;
    }

    public Integer getMax() {
        return (Integer)this.json.get(MAX);
    }

    public SliderOptions setRange(Boolean range) {
        this.json.put((Object)RANGE, (Object)range);
        return this;
    }

    public Boolean getRange() {
        return (Boolean)this.json.get(RANGE);
    }

    public SliderOptions setAnimate(Boolean animate) {
        this.json.put((Object)ANIMATE, (Object)animate);
        return this;
    }

    public Boolean getAnimate() {
        return (Boolean)this.json.get(ANIMATE);
    }

    public SliderOptions setOnChange(String body, String ... parametersNames) {
        this.putFunction(CHANGE, body, parametersNames);
        return this;
    }

    public SliderOptions setOnStart(String body, String ... parametersNames) {
        this.putFunction(START, body, parametersNames);
        return this;
    }

    public SliderOptions setOnStop(String body, String ... parametersNames) {
        this.putFunction(STOP, body, parametersNames);
        return this;
    }

    public SliderOptions setOnSlide(String body, String ... parametersNames) {
        this.putFunction(SLIDE, body, parametersNames);
        return this;
    }

    public JSONFunction getOnChange() {
        return (JSONFunction)this.json.get(CHANGE);
    }

    public SliderOptions setHandles(SliderHandleOptions ... handlesSettings) {
        if (handlesSettings != null && handlesSettings.length > 0) {
            JSONArray handlesArray = new JSONArray();
            for (SliderHandleOptions sliderHandleSettings : handlesSettings) {
                handlesArray.add((Object)sliderHandleSettings.getJSON());
            }
            this.json.put((Object)HANDLES, (Object)handlesArray);
        }
        return this;
    }

    public String toJSON() {
        return this.json.toString();
    }

    private void putFunction(String keyName, String body, String[] parametersNames) {
        JSONFunction function = parametersNames != null && parametersNames.length > 0 ? new JSONFunction(parametersNames, body) : new JSONFunction(body);
        this.json.put((Object)keyName, (Object)function);
    }
}

