/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.validation;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.wicketstuff.jquery.JQueryBehavior;

public class AjaxFormComponentValidatorBehaviour
extends AjaxFormComponentUpdatingBehavior {
    private static final long serialVersionUID = 1L;
    public static final String ERROR_COMPONENT_CLASS = "error";
    public static final String ERROR_MESSAGE_CLASS = "error";
    private boolean errorDetected = false;

    public AjaxFormComponentValidatorBehaviour() {
        this("onblur");
    }

    public AjaxFormComponentValidatorBehaviour(String event) {
        super(event);
    }

    protected void onUpdate(AjaxRequestTarget target) {
        if (this.errorDetected) {
            target.appendJavaScript((CharSequence)("$('#" + this.getComponent().getMarkupId() + "').removeClass('" + "error" + "');"));
            target.appendJavaScript((CharSequence)this.getRemovePreviousErrorsScript());
        }
    }

    protected String getRemovePreviousErrorsScript() {
        return "$('#" + this.getComponent().getMarkupId() + "').next().remove();";
    }

    protected void onError(AjaxRequestTarget target, RuntimeException e) {
        super.onError(target, e);
        target.appendJavaScript((CharSequence)this.getErrorJavascript());
        this.errorDetected = true;
    }

    protected String getErrorJavascript() {
        StringBuilder b = new StringBuilder();
        if (this.errorDetected) {
            b.append(this.getRemovePreviousErrorsScript());
        }
        b.append("$('#" + this.getComponent().getMarkupId() + "').parent().addClass('" + "error" + "');");
        List messages = Session.get().getFeedbackMessages().messages((IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(this.getComponent()));
        StringBuilder mb = new StringBuilder("");
        for (int i = 0; i < messages.size(); ++i) {
            String msg = ((FeedbackMessage)messages.get(i)).getMessage().toString().replace("'", "\\'");
            mb.append(msg);
            if (i + 1 >= messages.size()) continue;
            mb.append(this.getErrorSeparator());
        }
        b.append("$('#" + this.getComponent().getMarkupId() + "').after('<span class=\"" + "error" + "\">" + mb.toString() + "</span>');");
        return b.toString();
    }

    protected String getErrorSeparator() {
        return "<br/>";
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderJavaScriptReference(JQueryBehavior.JQUERY_JS);
    }
}

