/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.wicketstuff.jslibraries.Library;
import org.wicketstuff.jslibraries.Provider;
import org.wicketstuff.jslibraries.URLRenderer;
import org.wicketstuff.jslibraries.Version;
import org.wicketstuff.jslibraries.VersionDescriptor;
import org.wicketstuff.jslibraries.util.Assert;

public enum CDN implements Provider
{
    GOOGLE{
        private volatile Map<Library, GoogleRenderer> renderers;

        @Override
        public URL render(Library lib, Version version, boolean production) {
            URLRenderer r;
            Assert.parameterNotNull((Object)lib, "lib");
            Assert.parameterNotNull(version, "version");
            if (this.renderers == null) {
                this.renderers = new HashMap<Library, GoogleRenderer>();
                this.renderers.put(Library.JQUERY, new GoogleRenderer("jquery", "jquery", ".js", ".min.js"));
                this.renderers.put(Library.JQUERY_UI, new GoogleRenderer("jqueryui", "jquery-ui", ".js", ".min.js"));
                this.renderers.put(Library.MOOTOOLS_CORE, new GoogleRenderer("mootools", "mootools", ".js", "-yui-compressed.js"));
                this.renderers.put(Library.PROTOTYPE, new GoogleRenderer("prototype", "prototype", ".js"));
                this.renderers.put(Library.SCRIPTACULOUS, new GoogleRenderer("scriptaculous", "scriptaculous", ".js"));
                this.renderers.put(Library.YUI, new GoogleRenderer("yui", "build/yuiloader/yuiloader", ".js", "-min.js"));
                this.renderers.put(Library.DOJO, new GoogleRenderer("dojo", "dojo/dojo.xd.js", ".uncompressed.js", ""));
                this.renderers.put(Library.SWFOBJECT, new GoogleRenderer("swfobject", "swfobject", "_src.js", ".js"));
                this.renderers.put(Library.EXT_CORE, new GoogleRenderer("ext-core", "ext-core", "-debug.js", ".js"));
            }
            if ((r = (URLRenderer)this.renderers.get((Object)lib)) == null) {
                return null;
            }
            return r.render(lib, version, production);
        }
    }
    ,
    YAHOO{

        @Override
        public URL render(Library lib, Version version, boolean production) {
            Assert.parameterNotNull(version, "version");
            Assert.parameterNotNull((Object)lib, "lib");
            if (lib == Library.YUI) {
                String sign = production ? "-min" : "";
                try {
                    return new URL("http://yui.yahooapis.com/" + version.renderVersionNumbers() + "/build/yuiloader/yuiloader" + sign + ".js");
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Construction of Yahoo-URL failed.", e);
                }
            }
            return null;
        }
    };

    public static final CDN[] ANY;

    protected abstract URL render(Library var1, Version var2, boolean var3);

    @Override
    public IHeaderContributor getHeaderContributor(VersionDescriptor versionDescriptor, boolean production) {
        URL url;
        Assert.parameterNotNull(versionDescriptor, "versionDescriptor");
        Library lib = versionDescriptor.getLibrary();
        Version v = versionDescriptor.getVersion(this);
        if (lib.getVersions(this).contains(v) && (url = this.render(lib, v, production)) != null) {
            return new HeaderContributor(url.toExternalForm());
        }
        return null;
    }

    static {
        ANY = CDN.values();
    }

    private static class HeaderContributor
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;
        private final String url;

        public HeaderContributor(String url) {
            this.url = url;
        }

        public void renderHead(IHeaderResponse response) {
            response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)this.url));
        }
    }

    static class GoogleRenderer
    implements URLRenderer {
        private static final String URL_PREFIX = "http://ajax.googleapis.com/ajax/libs/";
        private final String path;
        private final String file;
        private final String suffix;
        private final String productionSuffix;

        private GoogleRenderer(String path, String file, String suffix, String productionSuffix) {
            this.path = path;
            this.file = file;
            this.suffix = suffix;
            this.productionSuffix = productionSuffix;
        }

        private GoogleRenderer(String path, String file, String suffix) {
            this(path, file, suffix, suffix);
        }

        @Override
        public URL render(Library lib, Version v, boolean production) {
            Assert.parameterNotNull((Object)lib, "lib");
            Assert.parameterNotNull(v, "v");
            String version = v.renderVersionNumbers();
            String spec = URL_PREFIX + this.path + "/" + version + "/" + this.file + (production ? this.productionSuffix : this.suffix);
            try {
                return new URL(spec);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

