/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.wicketstuff.jslibraries.LocalProvider;
import org.wicketstuff.jslibraries.Provider;
import org.wicketstuff.jslibraries.VersionDescriptor;
import org.wicketstuff.jslibraries.util.Assert;
import org.wicketstuff.jslibraries.util.WicketDeploymentState;

public class JSLib {
    private static final MetaDataKey<Provider[]> PROVIDER_KEY = new MetaDataKey<Provider[]>(){
        private static final long serialVersionUID = 1L;
    };

    private JSLib() {
    }

    public static void setOverrideProviders(Application app, Provider ... providers) {
        Assert.parameterNotNull(app, "app");
        Assert.parameterNotNull(providers, "providers");
        app.setMetaData(PROVIDER_KEY, (Object)providers);
    }

    public static IHeaderContributor getHeaderContribution(VersionDescriptor versionDescriptor) {
        return JSLib.getHeaderContribution(versionDescriptor, WicketDeploymentState.isProduction(), LocalProvider.DEFAULT);
    }

    public static IHeaderContributor getHeaderContribution(VersionDescriptor versionDescriptor, Provider ... providers) {
        return JSLib.getHeaderContribution(versionDescriptor, WicketDeploymentState.isProduction(), providers);
    }

    public static IHeaderContributor getHeaderContribution(VersionDescriptor versionDescriptor, boolean production, Provider ... providers) {
        Provider[] prov = (Provider[])Application.get().getMetaData(PROVIDER_KEY);
        if (prov == null) {
            prov = providers;
        }
        if (prov != null) {
            for (Provider provider : prov) {
                IHeaderContributor hc = provider.getHeaderContributor(versionDescriptor, production);
                if (hc == null) continue;
                return hc;
            }
        }
        return null;
    }
}

