/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jslibraries.JSReference;
import org.wicketstuff.jslibraries.Library;
import org.wicketstuff.jslibraries.Provider;
import org.wicketstuff.jslibraries.VersionDescriptor;
import org.wicketstuff.jslibraries.util.Assert;

public class LocalProvider
implements Provider {
    static final LocalProvider DEFAULT = new LocalProvider();
    private final Map<Library, String> localFileNames = new HashMap<Library, String>();
    private final Map<Library, String> localProductionSignifiers = new HashMap<Library, String>();

    private LocalProvider() {
        this.localFileNames.put(Library.JQUERY, "jquery");
        this.localFileNames.put(Library.JQUERY_UI, "jquery-ui");
        this.localFileNames.put(Library.MOOTOOLS_CORE, "mootools-core");
        this.localFileNames.put(Library.MOOTOOLS_MORE, "mootools-more");
        this.localFileNames.put(Library.PROTOTYPE, "prototype");
        this.localFileNames.put(Library.SCRIPTACULOUS, "scriptaculous");
        this.localFileNames.put(Library.YUI, "yuiloader");
        this.localFileNames.put(Library.DOJO, "dojo");
        this.localFileNames.put(Library.SWFOBJECT, "swfobject");
        this.localFileNames.put(Library.EXT_CORE, "ext-core");
        this.localProductionSignifiers.put(Library.JQUERY, ".min");
        this.localProductionSignifiers.put(Library.JQUERY_UI, ".min");
        this.localProductionSignifiers.put(Library.MOOTOOLS_CORE, ".min");
        this.localProductionSignifiers.put(Library.MOOTOOLS_MORE, ".min");
        this.localProductionSignifiers.put(Library.PROTOTYPE, null);
        this.localProductionSignifiers.put(Library.SCRIPTACULOUS, null);
        this.localProductionSignifiers.put(Library.YUI, ".min");
        this.localProductionSignifiers.put(Library.DOJO, ".min");
        this.localProductionSignifiers.put(Library.SWFOBJECT, ".min");
        this.localProductionSignifiers.put(Library.EXT_CORE, ".min");
    }

    @Override
    public IHeaderContributor getHeaderContributor(VersionDescriptor versionDescriptor, boolean production) {
        Assert.parameterNotNull(versionDescriptor, "versionDescriptor");
        return new HeaderContributor(versionDescriptor, production);
    }

    String getLocalFileName(Library lib) {
        Assert.parameterNotNull((Object)lib, "lib");
        String name = this.localFileNames.get((Object)lib);
        if (name == null) {
            throw new IllegalArgumentException("Library '" + (Object)((Object)lib) + "' is unknown to '" + this.getClass().getSimpleName() + "'");
        }
        return name;
    }

    String getProductionSignifier(Library lib) {
        Assert.parameterNotNull((Object)lib, "lib");
        String signifier = this.localProductionSignifiers.get((Object)lib);
        return signifier;
    }

    private static class HeaderContributor
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;
        private final VersionDescriptor versionDescriptor;
        private final boolean production;

        public HeaderContributor(VersionDescriptor versionDescriptor, boolean production) {
            this.versionDescriptor = versionDescriptor;
            this.production = production;
        }

        public void renderHead(IHeaderResponse response) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JSReference.getReference(this.versionDescriptor, this.production)));
        }
    }
}

