/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import java.io.Serializable;
import java.util.Arrays;
import org.wicketstuff.jslibraries.util.Assert;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] mNumbers;

    public Version(int ... numbers) {
        this.mNumbers = numbers;
    }

    public int[] getNumbers() {
        return this.mNumbers;
    }

    @Override
    public int compareTo(Version other) {
        Assert.parameterNotNull(other, "other");
        for (int i = 0; i < this.mNumbers.length; ++i) {
            if (this.mNumbers[i] != other.mNumbers[i]) {
                return this.mNumbers[i] - other.mNumbers[i];
            }
            int next = i + 1;
            if (next >= this.mNumbers.length || next < other.mNumbers.length) continue;
            return 1;
        }
        return 0;
    }

    public boolean matches(Version other) {
        Assert.parameterNotNull(other, "other");
        if (other.mNumbers.length > this.mNumbers.length) {
            return false;
        }
        for (int i = 0; i < other.mNumbers.length; ++i) {
            if (this.mNumbers[i] == other.mNumbers[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return 'v' + this.renderVersionNumbers();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mNumbers);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return Arrays.equals(this.mNumbers, other.mNumbers);
    }

    protected String renderVersionNumbers() {
        StringBuffer sb = new StringBuffer();
        for (int num : this.mNumbers) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(num);
        }
        return sb.toString();
    }
}

