/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import java.io.Serializable;
import org.wicketstuff.jslibraries.Library;
import org.wicketstuff.jslibraries.Provider;
import org.wicketstuff.jslibraries.Version;
import org.wicketstuff.jslibraries.util.Assert;

public class VersionDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Library mLibrary;
    private final boolean mExact;
    private final Version mVersion;

    private VersionDescriptor(Library library, boolean exact, Version version) {
        Assert.parameterNotNull((Object)library, "library");
        Assert.parameterNotNull(version, "version");
        this.mLibrary = library;
        this.mVersion = version;
        this.mExact = exact;
    }

    public Library getLibrary() {
        return this.mLibrary;
    }

    public Version getVersion(Provider provider) {
        Assert.parameterNotNull(provider, "provider");
        Version mMatch = null;
        for (Version version : this.mLibrary.getVersions(provider)) {
            if (this.mExact) {
                if (!version.equals(this.mVersion)) continue;
                mMatch = version;
                break;
            }
            if (!version.matches(this.mVersion)) continue;
            mMatch = version;
        }
        return mMatch;
    }

    public static VersionDescriptor alwaysLatest(Library lib) {
        return VersionDescriptor.alwaysLatestOfVersion(lib, new int[0]);
    }

    public static VersionDescriptor exactVersion(Library lib, int ... numbers) {
        Assert.parameterNotNull((Object)lib, "lib");
        return new VersionDescriptor(lib, true, new Version(numbers));
    }

    public static VersionDescriptor alwaysLatestOfVersion(Library lib, int ... numbers) {
        Assert.parameterNotNull((Object)lib, "lib");
        return new VersionDescriptor(lib, false, new Version(numbers));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mLibrary == null ? 0 : this.mLibrary.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionDescriptor other = (VersionDescriptor)obj;
        return !(this.mLibrary == null ? other.mLibrary != null : !this.mLibrary.equals((Object)other.mLibrary));
    }
}

