/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries.util;

import java.util.EnumSet;

public class Assert {
    private Assert() {
    }

    public static final void isNotNull(Object reference) {
        Assert.isNotNull(reference, "Reference was null");
    }

    public static final void isNotNull(Object reference, String msg) {
        if (reference == null) {
            Assert.raiseError(msg);
        }
    }

    public static final void isNotNullAndNotEmpty(String reference) {
        Assert.isNotNullAndNotEmpty(reference, "Reference was null or empty");
    }

    public static final void isNotNullAndNotEmpty(String reference, String msg) {
        if (reference == null || reference.length() == 0) {
            Assert.raiseError(msg);
        }
    }

    public static final void isFalse(boolean value) {
        Assert.isFalse(value, "Value was true");
    }

    public static final void isFalse(boolean value, String msg) {
        if (value) {
            Assert.raiseError(msg);
        }
    }

    public static final void isNotFalse(boolean value) {
        Assert.isNotFalse(value, "Value was false");
    }

    public static final void isNotFalse(boolean value, String msg) {
        if (!value) {
            Assert.raiseError(msg);
        }
    }

    public static final void isTrue(boolean value) {
        Assert.isTrue(value, "Value was false");
    }

    public static final void isTrue(boolean value, String msg) {
        if (!value) {
            Assert.raiseError(msg);
        }
    }

    public static final void isNotTrue(boolean value) {
        Assert.isNotTrue(value, "Value was true");
    }

    public static final void isNotTrue(boolean value, String msg) {
        if (value) {
            Assert.raiseError(msg);
        }
    }

    public static final void raiseError(String error) {
        throw new AssertionFailedException(error);
    }

    public static final void raiseError(String error, Exception e) {
        throw new AssertionFailedException(error, e);
    }

    public static void isEqual(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return;
        }
        if (obj1 != null && !obj1.equals(obj2)) {
            Assert.raiseError("'" + obj1 + "' and '" + obj2 + "' are not equal");
        }
    }

    public static void parameterNotNull(Object reference, String nameOfParameter) {
        if (reference == null) {
            Assert.raiseError("Parameter '" + nameOfParameter + "' is not expected to be null.");
        }
    }

    public static void isNull(Object object, String string) {
        if (object != null) {
            Assert.raiseError(string);
        }
    }

    public static void parameterInRange(int value, int min, int max, String string) {
        Assert.isTrue(min <= value && value <= max, "Parameter '" + string + "' must be in range of " + min + " <= " + string + " <= " + max + ". Current value was " + value);
    }

    public static void parameterLegal(boolean condition, String parameter) {
        Assert.isTrue(condition, "Parameter '" + parameter + "' is not legal.");
    }

    public static void parameterNotEmpty(String reference, String nameOfParameter) {
        if ("".equals(reference)) {
            Assert.raiseError("Parameter '" + nameOfParameter + "' is not expected to be empty.");
        }
    }

    public static <T extends Enum<T>> void enumContains(EnumSet<T> supportedQueryMode, T mode) {
        Assert.isTrue(true, "");
    }

    private static class AssertionFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AssertionFailedException(String detail) {
            super(detail);
        }

        public AssertionFailedException(String detail, Throwable e) {
            super(detail, e);
        }
    }
}

