/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jwicket.JQueryCssResourceReference;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JQueryResourceReferenceType;
import org.wicketstuff.jwicket.JsMap;

public abstract class JQueryAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final JQueryResourceReference baseLibrary;
    private final JQueryResourceReference[] requiredLibraries;
    private final List<JQueryResourceReference> additionLibraries = new ArrayList<JQueryResourceReference>();
    private List<JQueryCssResourceReference> cssResources;
    protected String rawOptions = null;
    private final List<JavaScriptResourceReference> userProvidedResourceReferences = new ArrayList<JavaScriptResourceReference>();

    public JQueryAjaxBehavior(JQueryResourceReference baseLibrary) {
        this(baseLibrary, new JQueryResourceReference[0]);
    }

    public JQueryAjaxBehavior(JQueryResourceReference baseLibrary, JQueryResourceReference ... requiredLibraries) {
        this.baseLibrary = baseLibrary;
        this.requiredLibraries = requiredLibraries;
    }

    public void setRawOptions(String options) {
        this.rawOptions = options;
    }

    private void addJavascriptReference(IHeaderResponse response, JavaScriptResourceReference resource) {
        if (!response.wasRendered((Object)resource)) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)resource));
            response.markRendered((Object)resource);
        }
    }

    private void addJavascriptReference(IHeaderResponse response, JQueryResourceReference resource) {
        if (!response.wasRendered((Object)resource)) {
            if (resource instanceof JQueryCssResourceReference) {
                response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)resource));
            } else if (resource.hasId()) {
                response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)resource, (String)resource.getId()));
            } else {
                response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)resource));
            }
            response.markRendered((Object)resource);
        }
    }

    private void addCssResourceReference(IHeaderResponse response, JQueryCssResourceReference resource) {
        if (!response.wasRendered((Object)resource)) {
            response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)resource));
            response.markRendered((Object)resource);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.userProvidedResourceReferences.size() == 0) {
            if (this.baseLibrary != null) {
                this.addJavascriptReference(response, this.baseLibrary);
            }
            if (this.requiredLibraries != null) {
                for (JQueryResourceReference jQueryResourceReference : this.requiredLibraries) {
                    this.addJavascriptReference(response, jQueryResourceReference);
                }
            }
        } else {
            for (JavaScriptResourceReference userLibrary : this.userProvidedResourceReferences) {
                this.addJavascriptReference(response, userLibrary);
            }
            if (this.baseLibrary != null && this.baseLibrary.getType() == JQueryResourceReferenceType.NOT_OVERRIDABLE) {
                this.addJavascriptReference(response, this.baseLibrary);
            }
            if (this.requiredLibraries != null) {
                for (JQueryResourceReference jQueryResourceReference : this.requiredLibraries) {
                    if (jQueryResourceReference.getType() != JQueryResourceReferenceType.NOT_OVERRIDABLE) continue;
                    this.addJavascriptReference(response, jQueryResourceReference);
                }
            }
        }
        for (JQueryResourceReference res : this.additionLibraries) {
            this.addJavascriptReference(response, res);
        }
        if (this.cssResources != null) {
            for (JQueryCssResourceReference res : this.cssResources) {
                this.addCssResourceReference(response, res);
            }
        }
    }

    public void addUserProvidedResourceReferences(JavaScriptResourceReference ... resources) {
        this.userProvidedResourceReferences.addAll(Arrays.asList(resources));
    }

    public List<JavaScriptResourceReference> getUserProvidedResourceReferences() {
        return this.userProvidedResourceReferences;
    }

    protected final void addUserProvidedResourceReferences(JQueryResourceReference ... resources) {
        Collections.addAll(this.additionLibraries, resources);
    }

    protected void respond(AjaxRequestTarget target) {
    }

    protected void printParameters(PrintStream stream, Map<String, String[]> parameterMap) {
        for (String key : parameterMap.keySet()) {
            String valuesString = "";
            for (String value : parameterMap.get(key)) {
                if (valuesString.length() > 0) {
                    valuesString = valuesString + ", ";
                }
                valuesString = valuesString + value;
            }
            stream.println("\t" + key + " = " + valuesString);
        }
    }

    protected void printParameters(Map<String, String[]> parameterMap) {
        this.printParameters(System.out, parameterMap);
    }

    protected void addCssResources(JQueryCssResourceReference ... res) {
        if (res == null || res.length == 0) {
            return;
        }
        if (this.cssResources == null) {
            this.cssResources = new ArrayList<JQueryCssResourceReference>();
        }
        Collections.addAll(this.cssResources, res);
    }

    protected static class JsAjaxCallbackFunction
    extends JsFunction {
        private static final long serialVersionUID = 1L;

        public JsAjaxCallbackFunction(AbstractAjaxBehavior behavior) {
            super("function() { Wicket.Ajax.get('" + behavior.getCallbackUrl() + "'); }");
        }
    }

    public static class JsFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String function;

        public JsFunction(String function) {
            this.function = function;
        }

        public String getFunction() {
            return this.function;
        }

        public String toString() {
            return this.function;
        }

        public void toString(StringBuffer buffer) {
            buffer.append(this.function);
        }
    }

    protected static class JsBuilder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final StringBuffer buffer = new StringBuffer();

        public JsBuilder() {
        }

        public JsBuilder(Object object) {
            this.append(object);
        }

        public void append(Object object) {
            if (object instanceof JsMap) {
                ((JsMap)object).toString(this.buffer, null);
            } else if (object instanceof Boolean) {
                this.buffer.append(((Boolean)object).toString());
            } else if (object instanceof JsFunction) {
                ((JsFunction)object).toString(this.buffer);
            } else if (object instanceof String[]) {
                this.buffer.append("[");
                boolean first = true;
                for (String s : (String[])object) {
                    if (!first) {
                        this.buffer.append(",");
                    }
                    this.buffer.append("'");
                    this.buffer.append(s);
                    this.buffer.append("'");
                    first = false;
                }
                this.buffer.append("]");
            } else {
                this.buffer.append(object.toString());
            }
        }

        public String toScriptTag() {
            return "\n" + this.buffer.toString() + "\n";
        }

        public String toString() {
            return this.buffer.toString();
        }

        public int length() {
            return this.buffer.length();
        }
    }
}

