/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.request.Request;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JQueryResourceReferenceType;
import org.wicketstuff.jwicket.SpecialKey;

public class SpecialKeys
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final JQueryResourceReference specialKeysJs = new JQueryResourceReference(SpecialKeys.class, "SpecialKeys.js", JQueryResourceReferenceType.NOT_OVERRIDABLE);
    private final List<SpecialKey> specialKeys = new ArrayList<SpecialKey>();

    public SpecialKeys(SpecialKey ... additionalSpecialKeys) {
        Collections.addAll(this.specialKeys, additionalSpecialKeys);
    }

    public SpecialKeys(Request request) {
        String rawKeys = request.getRequestParameters().getParameterValue("keys").toString();
        if (rawKeys != null && rawKeys.length() > 0) {
            String[] strings;
            for (String string : strings = Strings.split((String)rawKeys, (char)',')) {
                this.specialKeys.add(SpecialKey.getSpecialKey(string));
            }
        }
    }

    public List<SpecialKey> getSpecialKeys() {
        return this.specialKeys;
    }

    public void addSpecialKeys(SpecialKey ... additionalSpecialKeys) {
        Collections.addAll(this.specialKeys, additionalSpecialKeys);
    }

    public void removeSpecialKeys(SpecialKey ... additionalSpecialKeys) {
        for (SpecialKey key : additionalSpecialKeys) {
            this.specialKeys.remove((Object)key);
        }
    }

    public boolean is(SpecialKey ... keys) {
        for (SpecialKey key : keys) {
            if (this.specialKeys.contains((Object)key)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SpecialKey key : this.specialKeys) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append((Object)key);
        }
        return sb.toString();
    }
}

