/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.datepicker;

import java.io.Serializable;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jwicket.IStyleResolver;
import org.wicketstuff.jwicket.JQueryAjaxBehavior;
import org.wicketstuff.jwicket.JQueryCssResourceReference;
import org.wicketstuff.jwicket.JQueryDurableAjaxBehavior;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JQuerySpeed;
import org.wicketstuff.jwicket.JsMap;
import org.wicketstuff.jwicket.JsScript;
import org.wicketstuff.jwicket.SpecialKeys;

public class DatePicker
extends JQueryDurableAjaxBehavior
implements IStyleResolver {
    private static final long serialVersionUID = 1L;
    public static final JQueryResourceReference uiDatepickerJs = new JQueryResourceReference(DatePicker.class, "jquery.ui.datepicker.js");
    public static final JQueryResourceReference uiDatepickerJs_de = new JQueryResourceReference(DatePicker.class, "jquery.ui.datepicker-de.js");
    public static final JQueryResourceReference datePickerDefaultShowDayState = new JQueryResourceReference(DatePicker.class, "datePickerDefaultShowDayState.js");
    protected JsMap options = new JsMap();
    private String cssClass = null;
    private boolean onSelectNotificationWanted = false;
    private boolean onCloseNotificationWanted = false;
    private boolean onChangeMonthYearNotificationWanted = false;
    private boolean onBeforeShowNotificationWanted = false;
    private Collection<ShowDay> showDayStates = null;
    private boolean dayCheckerRendered = false;

    public DatePicker() {
        super(new JQueryResourceReference(DatePicker.class, "jquery.ui.core.js"), new JQueryResourceReference[]{SpecialKeys.specialKeysJs, datePickerDefaultShowDayState, uiDatepickerJs});
        this.initDatePicker();
    }

    public DatePicker(ResourceReference icon) {
        this();
        this.setButtonImage(icon);
    }

    public DatePicker(CharSequence icon) {
        this();
        this.setButtonImage(icon.toString());
    }

    private void initDatePicker() {
        this.addCssResources(this.getCssResources());
        Locale locale = Session.get().getLocale();
        if (locale != null) {
            this.addUserProvidedResourceReferences(new JQueryResourceReference[]{new JQueryResourceReference(DatePicker.class, "jquery.ui.datepicker-" + locale.getLanguage() + ".js")});
        }
        this.setRestoreAfterRedraw(true);
    }

    protected void respond(AjaxRequestTarget target) {
        Request request;
        Component component = this.getComponent();
        if (component != null && (request = component.getRequest()) != null) {
            EventType eventType = EventType.stringToType(request.getRequestParameters().getParameterValue("wicketDatepickerEvent").toString());
            if (eventType == EventType.ON_SELECT) {
                String selectedDate = request.getRequestParameters().getParameterValue("date").toString();
                SpecialKeys specialKeys = new SpecialKeys(request);
                this.onSelect(target, selectedDate, specialKeys);
                Locale locale = Session.get().getLocale();
                DateFormat df = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3);
                java.util.Date parsedDate = null;
                Date parsedSqlDate = null;
                try {
                    parsedDate = df.parse(selectedDate);
                    parsedSqlDate = new Date(parsedDate.getTime());
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Error converting '" + selectedDate + "' to a Date object.", (Throwable)e);
                }
                this.onSelect(target, parsedDate, specialKeys);
                this.onSelect(target, parsedSqlDate, specialKeys);
                if (component instanceof FormComponent) {
                    ((FormComponent)component).inputChanged();
                }
            } else if (eventType == EventType.ON_CLOSE) {
                this.onClose(target, request.getRequestParameters().getParameterValue("date").toString(), new SpecialKeys(request));
            } else if (eventType == EventType.ON_CHANGE_MONTH_YEAR) {
                this.onChangeMonthYear(target, request.getRequestParameters().getParameterValue("year").toString(), request.getRequestParameters().getParameterValue("month").toString(), new SpecialKeys(request));
            } else if (eventType == EventType.BEFORE_SHOW) {
                this.onBeforeShow(target);
            }
        }
    }

    public DatePicker setButtonImageOnly(boolean value) {
        if (!value) {
            this.options.remove((Object)"buttonImageOnly");
        } else {
            this.options.put((Object)"buttonImageOnly", (Object)value);
        }
        return this;
    }

    public DatePicker setButtonImageOnly(AjaxRequestTarget target, boolean value) {
        this.setButtonImageOnly(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','buttonImageOnly'," + value + ");"));
        return this;
    }

    public DatePicker setAutoSize(boolean value) {
        if (!value) {
            this.options.remove((Object)"autoSize");
        } else {
            this.options.put((Object)"autoSize", (Object)value);
        }
        return this;
    }

    public DatePicker setAutoSize(AjaxRequestTarget target, boolean value) {
        this.setAutoSize(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','autoSize'," + value + ");"));
        return this;
    }

    public DatePicker setButtonText(String value) {
        if (value == null) {
            this.options.remove((Object)"buttonText");
        } else {
            this.options.put((Object)"buttonText", (Object)value);
        }
        return this;
    }

    public DatePicker setButtonText(AjaxRequestTarget target, String value) {
        this.setButtonText(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','buttonText','" + value + "');"));
        return this;
    }

    public DatePicker setButtonImage(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"buttonImage");
            this.options.remove((Object)"showOn");
        } else {
            this.options.put((Object)"buttonImage", (Object)value);
            this.options.put((Object)"showOn", (Object)"button");
        }
        return this;
    }

    public DatePicker setButtonImage(AjaxRequestTarget target, String value) {
        this.setButtonImage(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','buttonImage','" + (value == null ? "" : value) + "','showOn','button');"));
        return this;
    }

    public DatePicker setButtonImage(ResourceReference value) {
        if (value == null) {
            this.options.remove((Object)"buttonImage");
            this.options.remove((Object)"showOn");
        } else {
            this.options.put((Object)"buttonImage", (Object)("resources/" + value.getKey()));
            this.options.put((Object)"showOn", (Object)"button");
        }
        return this;
    }

    public DatePicker setButtonImage(AjaxRequestTarget target, ResourceReference value) {
        this.setButtonImage(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','buttonImage','" + (value == null ? "" : value.getKey()) + "','showOn','button');"));
        return this;
    }

    public DatePicker setChangeMonth(boolean value) {
        if (!value) {
            this.options.remove((Object)"changeMonth");
        } else {
            this.options.put((Object)"changeMonth", (Object)value);
        }
        return this;
    }

    public DatePicker setChangeMonth(AjaxRequestTarget target, boolean value) {
        this.setChangeMonth(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','changeMonth'," + value + ");"));
        return this;
    }

    public DatePicker setChangeYear(boolean value) {
        if (!value) {
            this.options.remove((Object)"changeYear");
        } else {
            this.options.put((Object)"changeYear", (Object)value);
        }
        return this;
    }

    public DatePicker setChangeYear(AjaxRequestTarget target, boolean value) {
        this.setChangeYear(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','changeYear'," + value + ");"));
        return this;
    }

    public DatePicker setCloseText(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"closeText");
        } else {
            this.options.put((Object)"closeText", (Object)value);
        }
        return this;
    }

    public DatePicker setCloseText(AjaxRequestTarget target, String value) {
        this.setCloseText(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','closeText','" + value + "');"));
        return this;
    }

    public DatePicker setConstraintInput(boolean value) {
        if (!value) {
            this.options.remove((Object)"constraintInput");
        } else {
            this.options.put((Object)"constraintInput", (Object)value);
        }
        return this;
    }

    public DatePicker setConstraintInput(AjaxRequestTarget target, boolean value) {
        this.setConstraintInput(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','constraintInput'," + value + ");"));
        return this;
    }

    public DatePicker setCurrentText(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"currentText");
        } else {
            this.options.put((Object)"currentText", (Object)value);
        }
        return this;
    }

    public DatePicker setCurrentText(AjaxRequestTarget target, String value) {
        this.setCurrentText(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','currentText','" + value + "');"));
        return this;
    }

    public DatePicker setDateFormat(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"dateFormat");
        } else {
            this.options.put((Object)"dateFormat", (Object)value);
        }
        return this;
    }

    public DatePicker setDateFormat(AjaxRequestTarget target, String value) {
        this.setDateFormat(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','dateFormat','" + value + "');"));
        return this;
    }

    public DatePicker setDate(AjaxRequestTarget target, java.util.Date date) {
        String jsDate = this.getJavaScriptDateObject(date);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('setDate'," + jsDate + ");"));
        return this;
    }

    public DatePicker setDefaultDate(java.util.Date date) {
        return this.addToOrRemoveOfOptions("defaultDate", date);
    }

    private DateFormat getLocalDateFormat() {
        Locale locale = Session.get().getLocale();
        DateFormat df = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3);
        return df;
    }

    public DatePicker setDuration(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"duration");
        } else {
            this.options.put((Object)"duration", (Object)value);
        }
        return this;
    }

    public DatePicker setDuration(AjaxRequestTarget target, String value) {
        this.setDuration(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','duration','" + value + "');"));
        return this;
    }

    public DatePicker setDuration(int value) {
        if (value <= 0) {
            this.options.remove((Object)"duration");
        } else {
            this.options.put((Object)"duration", (Object)value);
        }
        return this;
    }

    public DatePicker setDuration(AjaxRequestTarget target, int value) {
        this.setDuration(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','duration'," + value + ");"));
        return this;
    }

    public DatePicker setDuration(JQuerySpeed value) {
        if (value == null) {
            this.options.remove((Object)"duration");
        } else {
            this.options.put((Object)"duration", (Object)value.getSpeed());
        }
        return this;
    }

    public DatePicker setDuration(AjaxRequestTarget target, JQuerySpeed value) {
        this.setDuration(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','duration','" + value.getSpeed() + "');"));
        return this;
    }

    public DatePicker setYearRange(String value) {
        return this.addToOrRemoveOfOptions("yearRange", value);
    }

    public DatePicker setMaxDate(String value) {
        return this.addToOrRemoveOfOptions("maxDate", value);
    }

    private DatePicker addToOrRemoveOfOptions(String key, String value) {
        if (value == null) {
            this.options.remove((Object)key);
        } else {
            this.options.put((Object)key, (Object)value);
        }
        return this;
    }

    private DatePicker addToOrRemoveOfOptions(String key, java.util.Date value) {
        if (value == null) {
            this.options.remove((Object)key);
        } else {
            String jsDate = this.getJavaScriptDateObject(value);
            this.options.put((Object)key, (Object)new JsScript(jsDate));
        }
        return this;
    }

    public DatePicker setMaxDate(AjaxRequestTarget target, String value) {
        this.setMaxDate(value);
        this.addOptionToDatepicker(target, "maxDate", value);
        return this;
    }

    private void addOptionToDatepicker(AjaxRequestTarget target, String key, String value) {
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','" + key + "','" + value + "');"));
    }

    public DatePicker setMaxDate(java.util.Date value) {
        return this.addToOrRemoveOfOptions("maxDate", value);
    }

    public DatePicker setMaxDate(AjaxRequestTarget target, java.util.Date value) {
        this.setMaxDate(value);
        if (value == null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate',null);"));
        } else {
            String jsDate = this.getJavaScriptDateObject(value);
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate'," + jsDate + ");"));
        }
        return this;
    }

    private String getJavaScriptDateObject(java.util.Date value) {
        Locale locale = Session.get().getLocale();
        Calendar cal = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
        cal.setTime(value);
        return "new Date(" + cal.get(1) + "," + cal.get(2) + "," + cal.get(5) + ")";
    }

    public DatePicker setMaxDate(Date value) {
        if (value == null) {
            this.options.remove((Object)"maxDate");
        } else {
            Locale locale = Session.get().getLocale();
            Calendar cal = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
            cal.setTimeInMillis(value.getTime());
            String jsDate = "new Date(" + cal.get(1) + "," + cal.get(2) + "," + cal.get(5) + ")";
            this.options.put((Object)"maxDate", (Object)new JsScript(jsDate));
        }
        return this;
    }

    public DatePicker setMaxDate(AjaxRequestTarget target, Date value) {
        this.setMaxDate(value);
        if (value == null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate',null);"));
        } else {
            Locale locale = Session.get().getLocale();
            Calendar cal = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
            cal.setTimeInMillis(value.getTime());
            String jsDate = "new Date(" + cal.get(1) + "," + cal.get(2) + "," + cal.get(5) + ")";
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate'," + jsDate + ");"));
        }
        return this;
    }

    public DatePicker setMinDate(String value) {
        if (value == null) {
            this.options.remove((Object)"minDate");
        } else {
            this.options.put((Object)"minDate", (Object)value);
        }
        return this;
    }

    public DatePicker setMinDate(AjaxRequestTarget target, String value) {
        this.setMinDate(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate','" + value + "');"));
        return this;
    }

    public DatePicker setMinDate(java.util.Date value) {
        if (value == null) {
            this.options.remove((Object)"minDate");
        } else {
            String jsDate = this.getJavaScriptDateObject(value);
            this.options.put((Object)"minDate", (Object)new JsScript(jsDate));
        }
        return this;
    }

    public DatePicker setMinDate(AjaxRequestTarget target, java.util.Date value) {
        this.setMinDate(value);
        if (value == null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate',null);"));
        } else {
            String jsDate = this.getJavaScriptDateObject(value);
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate'," + jsDate + ");"));
        }
        return this;
    }

    public DatePicker setMinDate(Date value) {
        if (value == null) {
            this.options.remove((Object)"minDate");
        } else {
            Locale locale = Session.get().getLocale();
            Calendar cal = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
            cal.setTimeInMillis(value.getTime());
            String jsDate = "new Date(" + cal.get(1) + "," + cal.get(2) + "," + cal.get(5) + ")";
            this.options.put((Object)"minDate", (Object)new JsScript(jsDate));
        }
        return this;
    }

    public DatePicker setMinDate(AjaxRequestTarget target, Date value) {
        this.setMinDate(value);
        if (value == null) {
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate',null);"));
        } else {
            Locale locale = Session.get().getLocale();
            Calendar cal = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
            cal.setTimeInMillis(value.getTime());
            String jsDate = "new Date(" + cal.get(1) + "," + cal.get(2) + "," + cal.get(5) + ")";
            target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate'," + jsDate + ");"));
        }
        return this;
    }

    public DatePicker setNumberOfMonths(int value) {
        if (value == 0) {
            this.options.remove((Object)"numberOfMonths");
        } else {
            this.options.put((Object)"numberOfMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setNumberOfMonths(AjaxRequestTarget target, int value) {
        this.setNumberOfMonths(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','numberOfMonths'," + value + ");"));
        return this;
    }

    public DatePicker setNumberOfMonths(int rows, int columns) {
        if (rows == 0 || columns == 0) {
            this.options.remove((Object)"numberOfMonths");
        } else {
            this.options.put("numberOfMonths", new Object[]{rows, columns});
        }
        return this;
    }

    public DatePicker setNumberOfMonths(AjaxRequestTarget target, int rows, int columns) {
        this.setNumberOfMonths(rows, columns);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','numberOfMonths',[" + rows + "," + columns + "]);"));
        return this;
    }

    public DatePicker setSelectOtherMonths(boolean value) {
        if (!value) {
            this.options.remove((Object)"selectOtherMonths");
        } else {
            this.options.put((Object)"selectOtherMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setSelectOtherMonths(AjaxRequestTarget target, boolean value) {
        this.setSelectOtherMonths(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','selectOtherMonths'," + value + ");"));
        return this;
    }

    public DatePicker setShowAnim(ShowAnim value) {
        if (value == null) {
            this.options.remove((Object)"showAnim");
        } else {
            this.options.put((Object)"showAnim", (Object)value.getAnimName());
        }
        return this;
    }

    public DatePicker setShowAnim(AjaxRequestTarget target, ShowAnim value) {
        this.setShowAnim(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showAnim'," + value.getAnimName() + ");"));
        return this;
    }

    public DatePicker setShowButtonPanel(boolean value) {
        if (!value) {
            this.options.remove((Object)"showButtonPanel");
        } else {
            this.options.put((Object)"showButtonPanel", (Object)value);
        }
        return this;
    }

    public DatePicker setShowButtonPanel(AjaxRequestTarget target, boolean value) {
        this.setShowButtonPanel(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showButtonPanel'," + value + ");"));
        return this;
    }

    public DatePicker setShowCurrentAtPos(int value) {
        if (value == 0) {
            this.options.remove((Object)"showCurrentAtPos");
        } else {
            this.options.put((Object)"showCurrentAtPos", (Object)value);
        }
        return this;
    }

    public DatePicker setShowCurrentAtPos(AjaxRequestTarget target, int value) {
        this.setShowCurrentAtPos(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showCurrentAtPos'," + value + ");"));
        return this;
    }

    public DatePicker setShowMonthAfterYear(boolean value) {
        if (!value) {
            this.options.remove((Object)"showMonthAfterYear");
        } else {
            this.options.put((Object)"showMonthAfterYear", (Object)value);
        }
        return this;
    }

    public DatePicker setShowMonthAfterYear(AjaxRequestTarget target, boolean value) {
        this.setShowMonthAfterYear(value);
        target.appendJavaScript((CharSequence)(this.getJQueryObjectOfComponent(this.getComponent()) + ".datepicker('option','showMonthAfterYear'," + value + ");"));
        return this;
    }

    protected String getJQueryObjectOfComponent(Component component) {
        return "jQuery('#" + component.getMarkupId() + "')";
    }

    public DatePicker setShowOn(ShowOnTrigger value) {
        if (value == null) {
            this.options.remove((Object)"showOn");
        } else {
            this.options.put((Object)"showOn", (Object)value);
        }
        return this;
    }

    public DatePicker setShowOn(AjaxRequestTarget target, ShowOnTrigger value) {
        this.setShowOn(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showOn','" + value.getTriggerName() + "');"));
        return this;
    }

    public DatePicker setShowOtherMonths(boolean value) {
        if (!value) {
            this.options.remove((Object)"showOtherMonths");
        } else {
            this.options.put((Object)"showOtherMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setShowOtherMonths(AjaxRequestTarget target, boolean value) {
        this.setShowOtherMonths(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showOtherMonths'," + value + ");"));
        return this;
    }

    public DatePicker setShowWeek(boolean value) {
        if (!value) {
            this.options.remove((Object)"showWeek");
        } else {
            this.options.put((Object)"showWeek", (Object)value);
        }
        return this;
    }

    public DatePicker setShowWeek(AjaxRequestTarget target, boolean value) {
        this.setShowWeek(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showWeek'," + value + ");"));
        return this;
    }

    public DatePicker setStepMonths(int value) {
        if (value <= 0) {
            this.options.remove((Object)"stepMonths");
        } else {
            this.options.put((Object)"stepMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setStepMonths(AjaxRequestTarget target, int value) {
        this.setStepMonths(value);
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','stepMonths'," + value + ");"));
        return this;
    }

    public DatePicker setMonthNamesShort(String[] monthNamesShort) {
        if (monthNamesShort == null) {
            this.options.remove((Object)"monthNamesShort");
        } else {
            this.options.put("monthNamesShort", (Object[])monthNamesShort);
        }
        return this;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public DatePicker setWantOnSelectNotification(boolean value) {
        this.onSelectNotificationWanted = value;
        return this;
    }

    public DatePicker setWantOnCloseNotification(boolean value) {
        this.onCloseNotificationWanted = value;
        return this;
    }

    public DatePicker setWantOnChangeMonthYearNotification(boolean value) {
        this.onChangeMonthYearNotificationWanted = value;
        return this;
    }

    public DatePicker setWantOnBeforeShowNotificationWanted(boolean value) {
        this.onBeforeShowNotificationWanted = value;
        return this;
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
    }

    protected JQueryAjaxBehavior.JsBuilder getJsBuilder() {
        if (this.onBeforeShowNotificationWanted) {
            this.options.put((Object)EventType.BEFORE_SHOW.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(dateText,inst) { Wicket.Ajax.get({ 'u':'" + this.getCallbackUrl() + "', 'dep': [ function() {return {'" + "wicketDatepickerEvent" + "':'" + EventType.BEFORE_SHOW + "', 'keys':jQuery.jWicketSpecialKeysGetPressed()}}]" + "});}"));
        } else {
            this.options.remove((Object)EventType.BEFORE_SHOW.getEventName());
        }
        if (this.onSelectNotificationWanted) {
            this.options.put((Object)EventType.ON_SELECT.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(dateText,inst) { Wicket.Ajax." + this.configureOnSelectGetOrPost() + "({ 'u':'" + this.getCallbackUrl() + "', 'dep': [ function() {return {'date': dateText ,'" + "wicketDatepickerEvent" + "':'" + EventType.ON_SELECT + "', 'keys':jQuery.jWicketSpecialKeysGetPressed()}}]" + "});}"));
        } else {
            this.options.remove((Object)EventType.ON_SELECT.getEventName());
        }
        if (this.onCloseNotificationWanted) {
            this.options.put((Object)EventType.ON_CLOSE.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(dateText,inst) { Wicket.Ajax.get({ 'u':'" + this.getCallbackUrl() + "', 'dep': [ function() {return {'date': dateText ,'" + "wicketDatepickerEvent" + "':'" + EventType.ON_CLOSE + "', 'keys':jQuery.jWicketSpecialKeysGetPressed()}}]" + "});}"));
        } else {
            this.options.remove((Object)EventType.ON_CLOSE.getEventName());
        }
        if (this.onChangeMonthYearNotificationWanted) {
            this.options.put((Object)EventType.ON_CHANGE_MONTH_YEAR.eventName, (Object)this.onChangeMonthJsFunction());
        } else {
            this.options.remove((Object)EventType.ON_CHANGE_MONTH_YEAR.getEventName());
        }
        if (this.hasToAddBeforeShowDayToOptions()) {
            this.options.put((Object)EventType.BEFORE_SHOW_DAY.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(date) {return " + this.getCheckFunctionName() + "(date);" + "}"));
        } else {
            this.options.remove((Object)EventType.BEFORE_SHOW_DAY.getEventName());
        }
        JQueryAjaxBehavior.JsBuilder builder = new JQueryAjaxBehavior.JsBuilder();
        if (this.isAlreadyRendered()) {
            builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "+button').remove();"));
        }
        builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker("));
        builder.append((Object)"{");
        builder.append((Object)this.options.toString(this.rawOptions));
        builder.append((Object)"}");
        builder.append((Object)")");
        if (this.cssClass != null) {
            builder.append((Object)";jQuery('#ui-datepicker-div').wrap('<div class=\"");
            builder.append((Object)this.cssClass);
            builder.append((Object)"\" />')");
        }
        return builder;
    }

    protected JQueryAjaxBehavior.JsFunction onChangeMonthJsFunction() {
        return new JQueryAjaxBehavior.JsFunction("function(year,month,inst) { Wicket.Ajax.get({ 'u':'" + this.getCallbackUrl() + "', 'dep': [ function() {return {" + "'year': year" + ", 'month': month" + ",'" + "wicketDatepickerEvent" + "': '" + EventType.ON_CHANGE_MONTH_YEAR + "', 'keys': jQuery.jWicketSpecialKeysGetPressed()}}]" + "});}");
    }

    protected String configureOnSelectGetOrPost() {
        return AjaxCall.GET.getAxajCall();
    }

    protected boolean hasToAddBeforeShowDayToOptions() {
        return this.showDayStates != null && this.showDayStates.size() > 0;
    }

    protected void onBeforeShow(AjaxRequestTarget target) {
    }

    protected void onSelect(AjaxRequestTarget target, String pickedDate, SpecialKeys specialKeys) {
    }

    protected void onSelect(AjaxRequestTarget target, java.util.Date pickedDate, SpecialKeys specialKeys) {
    }

    protected void onSelect(AjaxRequestTarget target, Date pickedDate, SpecialKeys specialKeys) {
    }

    protected void onClose(AjaxRequestTarget target, String pickedDate, SpecialKeys specialKeys) {
    }

    protected void onChangeMonthYear(AjaxRequestTarget target, String year, String month, SpecialKeys specialKeys) {
    }

    public void addShowDayState(ShowDay state) {
        if (this.showDayStates == null) {
            this.showDayStates = new ArrayList<ShowDay>(1);
        }
        this.showDayStates.add(state);
        this.dayCheckerRendered = false;
    }

    public void setShowDayStates(Collection<ShowDay> states) {
        this.showDayStates = states;
        this.dayCheckerRendered = false;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.hasToAddBeforeShowDayToOptions() && !this.dayCheckerRendered) {
            this.dayCheckerRendered = true;
            StringBuilder sb = this.getJsShowDatesVariable();
            sb.append("var ");
            sb.append(this.getCheckFunctionName());
            sb.append(" = function(date) {\n");
            sb.append("   var hash = '';\n");
            sb.append("   var intVal = date.getDate();\n");
            sb.append("   if (intVal < 10)\n");
            sb.append("      hash += '0';\n");
            sb.append("   hash += intVal;\n");
            sb.append("   intVal = date.getMonth()+1;\n");
            sb.append("   if (intVal < 10)\n");
            sb.append("      hash += '0';\n");
            sb.append("   hash += intVal;\n");
            sb.append("   intVal = date.getFullYear();\n");
            sb.append("   if (intVal < 1000)\n");
            sb.append("      hash += '0';\n");
            sb.append("   if (intVal < 100)\n");
            sb.append("      hash += '0';\n");
            sb.append("   if (intVal < 10)\n");
            sb.append("      hash += '0';\n");
            sb.append("   hash += intVal;\n");
            sb.append("   var found = ");
            sb.append(this.getCheckFunctionName());
            sb.append("days[hash];\n");
            sb.append("   if (found != null)\n");
            sb.append("      return found;\n");
            sb.append("   else\n");
            sb.append("      return datePickerDefaultShowDayState;\n");
            sb.append("};");
            response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)sb.toString(), (String)(this.getCheckFunctionName() + "ID")));
        }
    }

    protected StringBuilder getJsShowDatesVariable() {
        StringBuilder sb = new StringBuilder();
        sb.append("window.").append(this.getCheckFunctionName()).append("days = {");
        if (this.showDayStates != null && this.showDayStates.size() > 0) {
            Calendar cal = Calendar.getInstance();
            boolean first = true;
            for (ShowDay day : this.showDayStates) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                cal.setTime(day.getDate());
                sb.append("'");
                int numVal = cal.get(5);
                if (numVal < 10) {
                    sb.append("0");
                }
                sb.append(numVal);
                numVal = cal.get(2) + 1;
                if (numVal < 10) {
                    sb.append("0");
                }
                sb.append(numVal);
                numVal = cal.get(1);
                if (numVal < 1000) {
                    sb.append("0");
                }
                if (numVal < 100) {
                    sb.append("0");
                }
                if (numVal < 10) {
                    sb.append("0");
                }
                sb.append(numVal);
                sb.append("':new Array(");
                sb.append(day.isSelectable() ? "true" : "false");
                sb.append(",'");
                sb.append(day.getCssClass());
                sb.append("','");
                sb.append(day.getTooltip());
                sb.append("')");
            }
        }
        sb.append("};\n");
        return sb;
    }

    private String getCheckFunctionName() {
        return "jWicketCheckBeforeShowDayFor" + this.getComponent().getMarkupId();
    }

    public void disable(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker( 'disable' );"));
        target.add(new Component[]{this.getComponent()});
    }

    public void refresh(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker( 'refresh' );"));
    }

    public void enable(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker( 'enable' );"));
        target.appendJavaScript((CharSequence)this.getJsBuilder().toString());
    }

    public JQueryCssResourceReference[] getCssResources() {
        return new JQueryCssResourceReference[]{new JQueryCssResourceReference(DatePicker.class, "css/jquery-ui.css"), new JQueryCssResourceReference(DatePicker.class, "css/jquery.ui.core.css"), new JQueryCssResourceReference(DatePicker.class, "css/jquery.ui.theme.css")};
    }

    public static enum ShowOnTrigger implements Serializable
    {
        FOCUS("focus"),
        BUTTON("button"),
        BOTH("both");

        private final String triggerName;

        private ShowOnTrigger(String triggerName) {
            this.triggerName = triggerName;
        }

        public String getTriggerName() {
            return this.triggerName;
        }

        public String toString() {
            return this.triggerName;
        }
    }

    public static enum ShowAnim implements Serializable
    {
        SHOW("show"),
        SLIDE_DOWN("slideSown"),
        FADE_IN("fadeIn");

        private final String animName;

        private ShowAnim(String animName) {
            this.animName = animName;
        }

        public String getAnimName() {
            return this.animName;
        }

        public String toString() {
            return this.animName;
        }
    }

    private static enum EventType implements Serializable
    {
        UNKNOWN("*"),
        BEFORE_SHOW("beforeShow"),
        BEFORE_SHOW_DAY("beforeShowDay"),
        ON_CHANGE_MONTH_YEAR("onChangeMonthYear"),
        ON_CLOSE("onClose"),
        ON_SELECT("onSelect");

        public static final String IDENTIFIER = "wicketDatepickerEvent";
        private final String eventName;

        private EventType(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static EventType stringToType(String s) {
            for (EventType t : EventType.values()) {
                if (!t.getEventName().equals(s)) continue;
                return t;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.eventName;
        }
    }

    public static class ShowDay
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private java.util.Date date;
        private boolean selectable;
        private String cssClass;
        private String tooltip;

        public ShowDay(java.util.Date date, boolean selectable) {
            this(date, selectable, "", "");
        }

        public ShowDay(java.util.Date date, boolean selectable, String cssClass) {
            this(date, selectable, cssClass, "");
        }

        public ShowDay(java.util.Date date, boolean selectable, String cssClass, String tooltip) {
            this.setDate(date);
            this.setSelectable(selectable);
            this.setCssClass(cssClass);
            this.setTooltip(tooltip);
        }

        public java.util.Date getDate() {
            return this.date;
        }

        public void setDate(java.util.Date value) {
            this.date = value;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public void setSelectable(boolean value) {
            this.selectable = value;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public void setCssClass(String value) {
            this.cssClass = value;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public void setTooltip(String value) {
            this.tooltip = value;
        }

        public String toString() {
            return "ShowDay: selectable=" + this.isSelectable() + ", CSS class=" + this.getCssClass() + ", tooltip=" + this.getTooltip();
        }
    }

    protected static enum AjaxCall implements Serializable
    {
        GET("get"),
        POST("post");

        private final String axajCall;

        private AjaxCall(String ajaxCall) {
            this.axajCall = ajaxCall;
        }

        public String getAxajCall() {
            return this.axajCall;
        }
    }
}

